/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.cache.impl.CacheEntriesWithCursor;
import com.hazelcast.cache.impl.CacheProxy;
import com.hazelcast.cache.impl.operation.CacheFetchEntriesOperation;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.cache.impl.ClientCacheProxy;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.clientside.HazelcastClientProxy;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CacheIterateEntriesCodec;
import com.hazelcast.client.impl.protocol.codec.MapFetchEntriesCodec;
import com.hazelcast.client.impl.protocol.codec.MapFetchWithQueryCodec;
import com.hazelcast.client.impl.proxy.ClientMapProxy;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.cluster.Address;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.instance.impl.HazelcastInstanceImpl;
import com.hazelcast.internal.iteration.IterationPointer;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.util.IterationType;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.execution.init.Contexts;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.ImdgUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.map.impl.LazyMapEntry;
import com.hazelcast.map.impl.iterator.AbstractCursor;
import com.hazelcast.map.impl.iterator.MapEntriesWithCursor;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.operation.MapOperationProvider;
import com.hazelcast.map.impl.proxy.MapProxyImpl;
import com.hazelcast.map.impl.query.Query;
import com.hazelcast.map.impl.query.QueryResult;
import com.hazelcast.map.impl.query.QueryResultRow;
import com.hazelcast.map.impl.query.ResultSegment;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.partition.Partition;
import com.hazelcast.projection.Projection;
import com.hazelcast.query.Predicate;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.operationservice.OperationService;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ReadMapOrCacheP<F extends CompletableFuture, B, R>
extends AbstractProcessor {
    private static final int MAX_PARALLEL_READ = 5;
    private static final int MAX_FETCH_SIZE = 2048;
    private final Reader<F, B, R> reader;
    private final int[] partitionIds;
    private final IterationPointer[][] readPointers;
    private final int maxParallelRead;
    private F[] readFutures;
    private List<R> currentBatch = Collections.emptyList();
    private int currentBatchPosition;
    private int currentPartitionIndex = -1;
    private int numCompletedPartitions;
    private int nextPartitionReadIndex;
    private int partitionReadCount;
    private Object pendingItem;

    private ReadMapOrCacheP(@Nonnull Reader<F, B, R> reader, @Nonnull int[] partitionIds) {
        this.reader = reader;
        this.partitionIds = partitionIds;
        this.maxParallelRead = Math.min(partitionIds.length, 5);
        this.readPointers = new IterationPointer[partitionIds.length][];
        Arrays.fill((Object[])this.readPointers, new IterationPointer[]{new IterationPointer(Integer.MAX_VALUE, -1)});
    }

    @Override
    public boolean complete() {
        if (this.readFutures == null) {
            this.initialRead();
        }
        while (this.emitResultSet()) {
            if (this.tryGetNextResultSet()) continue;
            return this.numCompletedPartitions == this.partitionIds.length;
        }
        return false;
    }

    private void initialRead() {
        this.readFutures = new CompletableFuture[this.partitionIds.length];
        for (int i = 0; i < this.maxParallelRead; ++i) {
            this.readFutures[i] = this.reader.readBatch(this.partitionIds[i], this.readPointers[i]);
        }
        this.nextPartitionReadIndex = this.maxParallelRead;
        this.partitionReadCount = this.maxParallelRead;
    }

    private boolean emitResultSet() {
        if (this.pendingItem != null && !this.tryEmit(this.pendingItem)) {
            return false;
        }
        this.pendingItem = null;
        while (this.currentBatchPosition < this.currentBatch.size()) {
            Object item;
            if ((item = this.reader.toObject(this.currentBatch.get(this.currentBatchPosition++))) == null || this.tryEmit(item)) continue;
            this.pendingItem = item;
            return false;
        }
        return true;
    }

    private boolean tryGetNextResultSet() {
        while (this.currentBatch.size() == this.currentBatchPosition && ++this.currentPartitionIndex < this.partitionIds.length) {
            IterationPointer[] partitionPointers = this.readPointers[this.currentPartitionIndex];
            if (this.isDone(partitionPointers)) {
                assert (this.readFutures[this.currentPartitionIndex] == null) : "future not null";
                continue;
            }
            F future = this.readFutures[this.currentPartitionIndex];
            if (future == null) {
                this.readNextPartition();
                continue;
            }
            if (!((CompletableFuture)future).isDone()) continue;
            B result = this.toBatchResult(future);
            this.readFutures[this.currentPartitionIndex] = null;
            --this.partitionReadCount;
            IterationPointer[] pointers = this.reader.toNextPointer(result);
            if (this.isDone(pointers)) {
                ++this.numCompletedPartitions;
            } else assert (!this.currentBatch.isEmpty()) : "empty but not terminal batch";
            this.currentBatch = this.reader.toRecordSet(result);
            this.currentBatchPosition = 0;
            this.readPointers[this.currentPartitionIndex] = pointers;
            this.readNextPartition();
        }
        if (this.currentPartitionIndex == this.partitionIds.length) {
            this.currentPartitionIndex = -1;
            return false;
        }
        return true;
    }

    private void readNextPartition() {
        if (this.partitionReadCount == this.maxParallelRead) {
            return;
        }
        if (this.nextPartitionReadIndex == this.partitionIds.length) {
            this.nextPartitionReadIndex = 0;
        }
        while (this.nextPartitionReadIndex < this.partitionIds.length) {
            IterationPointer[] pointers = this.readPointers[this.nextPartitionReadIndex];
            if (this.readFutures[this.nextPartitionReadIndex] != null || this.isDone(pointers)) {
                ++this.nextPartitionReadIndex;
                continue;
            }
            this.readFutures[this.nextPartitionReadIndex] = this.reader.readBatch(this.partitionIds[this.nextPartitionReadIndex], pointers);
            ++this.nextPartitionReadIndex;
            ++this.partitionReadCount;
            break;
        }
    }

    private boolean isDone(IterationPointer[] partitionPointers) {
        return partitionPointers[partitionPointers.length - 1].getIndex() < 0;
    }

    private B toBatchResult(F future) {
        B result;
        try {
            result = this.reader.toBatchResult(future);
        }
        catch (ExecutionException e) {
            Throwable ex = ExceptionUtil.peel(e);
            if (ex instanceof HazelcastSerializationException) {
                throw new JetException("Serialization error when reading the map: are the key, value, predicate and projection classes visible to IMDG? You need to use User Code Deployment, adding the classes to JetConfig isn't enough", e);
            }
            throw ExceptionUtil.rethrow(ex);
        }
        catch (InterruptedException e) {
            throw ExceptionUtil.rethrow(e);
        }
        return result;
    }

    static class RemoteMapQueryReader
    extends Reader<ClientInvocationFuture, MapFetchWithQueryCodec.ResponseParameters, Data> {
        private final Predicate predicate;
        private final Projection projection;
        private final ClientMapProxy clientMapProxy;

        RemoteMapQueryReader(@Nonnull HazelcastInstance hzInstance, @Nonnull String mapName, @Nonnull Predicate predicate, @Nonnull Projection projection) {
            super(mapName, r -> IterationPointer.decodePointers(r.iterationPointers), r -> r.results);
            this.predicate = predicate;
            this.projection = projection;
            this.clientMapProxy = (ClientMapProxy)hzInstance.getMap(mapName);
            this.serializationService = this.clientMapProxy.getContext().getSerializationService();
        }

        @Override
        @Nonnull
        public ClientInvocationFuture readBatch(int partitionId, IterationPointer[] pointers) {
            ClientMessage request = MapFetchWithQueryCodec.encodeRequest(this.objectName, IterationPointer.encodePointers(pointers), 2048, this.serializationService.toData(this.projection), this.serializationService.toData(this.predicate));
            ClientInvocation clientInvocation = new ClientInvocation((HazelcastClientInstanceImpl)this.clientMapProxy.getContext().getHazelcastInstance(), request, (Object)this.objectName, partitionId);
            return clientInvocation.invoke();
        }

        @Override
        @Nonnull
        public MapFetchWithQueryCodec.ResponseParameters toBatchResult(@Nonnull ClientInvocationFuture future) throws ExecutionException, InterruptedException {
            return MapFetchWithQueryCodec.decodeResponse((ClientMessage)future.get());
        }

        @Override
        @Nullable
        public Object toObject(@Nonnull Data data) {
            return this.serializationService.toObject(data);
        }
    }

    static class RemoteMapReader
    extends Reader<ClientInvocationFuture, MapFetchEntriesCodec.ResponseParameters, Map.Entry<Data, Data>> {
        private final ClientMapProxy clientMapProxy;

        RemoteMapReader(@Nonnull HazelcastInstance hzInstance, @Nonnull String mapName) {
            super(mapName, parameters -> IterationPointer.decodePointers(parameters.iterationPointers), parameters -> parameters.entries);
            this.clientMapProxy = (ClientMapProxy)hzInstance.getMap(mapName);
            this.serializationService = this.clientMapProxy.getContext().getSerializationService();
        }

        @Override
        @Nonnull
        public ClientInvocationFuture readBatch(int partitionId, IterationPointer[] pointers) {
            ClientMessage request = MapFetchEntriesCodec.encodeRequest(this.objectName, IterationPointer.encodePointers(pointers), 2048);
            ClientInvocation clientInvocation = new ClientInvocation((HazelcastClientInstanceImpl)this.clientMapProxy.getContext().getHazelcastInstance(), request, (Object)this.objectName, partitionId);
            return clientInvocation.invoke();
        }

        @Override
        @Nonnull
        public MapFetchEntriesCodec.ResponseParameters toBatchResult(@Nonnull ClientInvocationFuture future) throws ExecutionException, InterruptedException {
            return MapFetchEntriesCodec.decodeResponse((ClientMessage)future.get());
        }

        @Nullable
        public Map.Entry<Data, Data> toObject(@Nonnull Map.Entry<Data, Data> entry) {
            return new LazyMapEntry<Data, Data>(entry.getKey(), entry.getValue(), this.serializationService);
        }
    }

    static class LocalMapQueryReader
    extends Reader<InternalCompletableFuture<ResultSegment>, ResultSegment, QueryResultRow> {
        private final Predicate predicate;
        private final Projection projection;
        private final MapProxyImpl mapProxyImpl;

        LocalMapQueryReader(@Nonnull HazelcastInstance hzInstance, @Nonnull InternalSerializationService serializationService, @Nonnull String mapName, @Nonnull Predicate predicate, @Nonnull Projection projection) {
            super(mapName, ResultSegment::getPointers, segment -> ((QueryResult)segment.getResult()).getRows());
            this.predicate = predicate;
            this.projection = projection;
            this.mapProxyImpl = (MapProxyImpl)hzInstance.getMap(mapName);
            this.serializationService = serializationService;
        }

        @Override
        @Nonnull
        public InternalCompletableFuture<ResultSegment> readBatch(int partitionId, IterationPointer[] pointers) {
            MapOperationProvider operationProvider = this.mapProxyImpl.getOperationProvider();
            MapOperation op = operationProvider.createFetchWithQueryOperation(this.objectName, pointers, 2048, Query.of().mapName(this.objectName).iterationType(IterationType.VALUE).predicate(this.predicate).projection(this.projection).build());
            return this.mapProxyImpl.getOperationService().invokeOnPartition(this.mapProxyImpl.getServiceName(), op, partitionId);
        }

        @Override
        @Nullable
        public Object toObject(@Nonnull QueryResultRow record) {
            return this.serializationService.toObject(record.getValue());
        }
    }

    static class LocalMapReader
    extends Reader<InternalCompletableFuture<MapEntriesWithCursor>, MapEntriesWithCursor, Map.Entry<Data, Data>> {
        private final MapProxyImpl mapProxyImpl;

        LocalMapReader(@Nonnull HazelcastInstance hzInstance, @Nonnull InternalSerializationService serializationService, @Nonnull String mapName) {
            super(mapName, AbstractCursor::getIterationPointers, AbstractCursor::getBatch);
            this.mapProxyImpl = (MapProxyImpl)hzInstance.getMap(mapName);
            this.serializationService = serializationService;
        }

        @Override
        @Nonnull
        public InternalCompletableFuture<MapEntriesWithCursor> readBatch(int partitionId, IterationPointer[] pointers) {
            MapOperationProvider operationProvider = this.mapProxyImpl.getOperationProvider();
            MapOperation op = operationProvider.createFetchEntriesOperation(this.objectName, pointers, 2048);
            return this.mapProxyImpl.getOperationService().invokeOnPartition(this.mapProxyImpl.getServiceName(), op, partitionId);
        }

        @Override
        @Nullable
        public Object toObject(@Nonnull Map.Entry<Data, Data> dataEntry) {
            return new LazyMapEntry(dataEntry.getKey(), dataEntry.getValue(), this.serializationService);
        }
    }

    static class RemoteCacheReader
    extends Reader<ClientInvocationFuture, CacheIterateEntriesCodec.ResponseParameters, Map.Entry<Data, Data>> {
        private final ClientCacheProxy clientCacheProxy;

        RemoteCacheReader(@Nonnull HazelcastInstance hzInstance, @Nonnull String cacheName) {
            super(cacheName, parameters -> IterationPointer.decodePointers(parameters.iterationPointers), parameters -> parameters.entries);
            this.clientCacheProxy = (ClientCacheProxy)hzInstance.getCacheManager().getCache(cacheName);
            this.serializationService = this.clientCacheProxy.getContext().getSerializationService();
        }

        @Override
        @Nonnull
        public ClientInvocationFuture readBatch(int partitionId, IterationPointer[] pointers) {
            String name = this.clientCacheProxy.getPrefixedName();
            ClientMessage request = CacheIterateEntriesCodec.encodeRequest(name, IterationPointer.encodePointers(pointers), 2048);
            HazelcastClientInstanceImpl client = (HazelcastClientInstanceImpl)this.clientCacheProxy.getContext().getHazelcastInstance();
            return new ClientInvocation(client, request, (Object)name, partitionId).invoke();
        }

        @Override
        @Nonnull
        public CacheIterateEntriesCodec.ResponseParameters toBatchResult(@Nonnull ClientInvocationFuture future) throws ExecutionException, InterruptedException {
            return CacheIterateEntriesCodec.decodeResponse((ClientMessage)future.get());
        }

        @Override
        @Nullable
        public Object toObject(@Nonnull Map.Entry<Data, Data> dataEntry) {
            return new LazyMapEntry(dataEntry.getKey(), dataEntry.getValue(), this.serializationService);
        }
    }

    static class LocalCacheReader
    extends Reader<InternalCompletableFuture<CacheEntriesWithCursor>, CacheEntriesWithCursor, Map.Entry<Data, Data>> {
        private final CacheProxy cacheProxy;

        LocalCacheReader(@Nonnull HazelcastInstance hzInstance, @Nonnull InternalSerializationService serializationService, @Nonnull String cacheName) {
            super(cacheName, CacheEntriesWithCursor::getPointers, CacheEntriesWithCursor::getEntries);
            this.cacheProxy = (CacheProxy)hzInstance.getCacheManager().getCache(cacheName);
            this.serializationService = serializationService;
        }

        @Override
        @Nonnull
        public InternalCompletableFuture<CacheEntriesWithCursor> readBatch(int partitionId, IterationPointer[] pointers) {
            CacheFetchEntriesOperation op = new CacheFetchEntriesOperation(this.cacheProxy.getPrefixedName(), pointers, 2048);
            OperationService operationService = this.cacheProxy.getOperationService();
            return operationService.invokeOnPartition(this.cacheProxy.getServiceName(), op, partitionId);
        }

        @Override
        @Nullable
        public Object toObject(@Nonnull Map.Entry<Data, Data> dataEntry) {
            return new LazyMapEntry(dataEntry.getKey(), dataEntry.getValue(), this.serializationService);
        }
    }

    static abstract class Reader<F extends CompletableFuture, B, R> {
        protected final String objectName;
        protected InternalSerializationService serializationService;
        private final FunctionEx<B, IterationPointer[]> toNextIterationPointerFn;
        private FunctionEx<B, List<R>> toRecordSetFn;

        Reader(@Nonnull String objectName, @Nonnull FunctionEx<B, IterationPointer[]> toNextIterationPointerFn, @Nonnull FunctionEx<B, List<R>> toRecordSetFn) {
            this.objectName = objectName;
            this.toNextIterationPointerFn = toNextIterationPointerFn;
            this.toRecordSetFn = toRecordSetFn;
        }

        @Nonnull
        abstract F readBatch(int var1, IterationPointer[] var2);

        @Nonnull
        B toBatchResult(@Nonnull F future) throws ExecutionException, InterruptedException {
            return (B)((CompletableFuture)future).get();
        }

        final IterationPointer[] toNextPointer(@Nonnull B result) {
            return this.toNextIterationPointerFn.apply(result);
        }

        @Nonnull
        final List<R> toRecordSet(@Nonnull B result) {
            return this.toRecordSetFn.apply(result);
        }

        @Nullable
        abstract Object toObject(@Nonnull R var1);
    }

    static class RemoteProcessorSupplier<F extends CompletableFuture, B, R>
    implements ProcessorSupplier {
        static final long serialVersionUID = 1L;
        private final String clientXml;
        private final FunctionEx<HazelcastInstance, Reader<F, B, R>> readerSupplier;
        private transient HazelcastClientProxy client;
        private transient int totalParallelism;
        private transient int baseIndex;

        RemoteProcessorSupplier(@Nonnull String clientXml, @Nonnull FunctionEx<HazelcastInstance, Reader<F, B, R>> readerSupplier) {
            this.clientXml = clientXml;
            this.readerSupplier = readerSupplier;
        }

        @Override
        public void init(@Nonnull ProcessorSupplier.Context context) {
            this.client = (HazelcastClientProxy)HazelcastClient.newHazelcastClient(ImdgUtil.asClientConfig(this.clientXml));
            this.totalParallelism = context.totalParallelism();
            this.baseIndex = context.memberIndex() * context.localParallelism();
        }

        @Override
        public void close(Throwable error) {
            if (this.client != null) {
                this.client.shutdown();
            }
        }

        @Nonnull
        public List<Processor> get(int count) {
            int remotePartitionCount = this.client.client.getClientPartitionService().getPartitionCount();
            return IntStream.range(0, count).mapToObj(i -> {
                int[] partitionIds = Util.roundRobinPart(remotePartitionCount, this.totalParallelism, this.baseIndex + i);
                return new ReadMapOrCacheP(this.readerSupplier.apply(this.client), partitionIds);
            }).collect(Collectors.toList());
        }
    }

    private static final class LocalProcessorSupplier<F extends CompletableFuture, B, R>
    implements ProcessorSupplier {
        static final long serialVersionUID = 1L;
        private final BiFunction<HazelcastInstance, InternalSerializationService, Reader<F, B, R>> readerSupplier;
        private final List<Integer> memberPartitions;
        private transient HazelcastInstanceImpl hzInstance;
        private transient InternalSerializationService serializationService;

        private LocalProcessorSupplier(@Nonnull BiFunction<HazelcastInstance, InternalSerializationService, Reader<F, B, R>> readerSupplier, @Nonnull List<Integer> memberPartitions) {
            this.readerSupplier = readerSupplier;
            this.memberPartitions = memberPartitions;
        }

        @Override
        public void init(@Nonnull ProcessorSupplier.Context context) {
            this.hzInstance = (HazelcastInstanceImpl)context.jetInstance().getHazelcastInstance();
            this.serializationService = ((Contexts.ProcSupplierCtx)context).serializationService();
        }

        @Nonnull
        public List<Processor> get(int count) {
            return Util.distributeObjects(count, this.memberPartitions).values().stream().map(partitions -> partitions.stream().mapToInt(Integer::intValue).toArray()).map(partitions -> new ReadMapOrCacheP(this.readerSupplier.apply(this.hzInstance, this.serializationService), (int[])partitions)).collect(Collectors.toList());
        }
    }

    static class LocalProcessorMetaSupplier<F extends CompletableFuture, B, R>
    implements ProcessorMetaSupplier {
        private static final long serialVersionUID = 1L;
        private final BiFunctionEx<HazelcastInstance, InternalSerializationService, Reader<F, B, R>> readerSupplier;
        private transient Map<Address, List<Integer>> addrToPartitions;

        LocalProcessorMetaSupplier(@Nonnull BiFunctionEx<HazelcastInstance, InternalSerializationService, Reader<F, B, R>> readerSupplier) {
            this.readerSupplier = readerSupplier;
        }

        @Override
        public void init(@Nonnull ProcessorMetaSupplier.Context context) {
            Set<Partition> partitions = context.jetInstance().getHazelcastInstance().getPartitionService().getPartitions();
            this.addrToPartitions = partitions.stream().collect(Collectors.groupingBy(partition -> partition.getOwner().getAddress(), Collectors.mapping(Partition::getPartitionId, Collectors.toList())));
        }

        @Nonnull
        public Function<Address, ProcessorSupplier> get(@Nonnull List<Address> addresses) {
            return address -> new LocalProcessorSupplier(this.readerSupplier, this.addrToPartitions.get(address));
        }

        @Override
        public int preferredLocalParallelism() {
            return 1;
        }
    }
}

