/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.nonapi.io.github.classgraph.classpath;

import com.hazelcast.jet.io.github.classgraph.ModuleRef;
import com.hazelcast.jet.nonapi.io.github.classgraph.scanspec.ScanSpec;
import com.hazelcast.jet.nonapi.io.github.classgraph.utils.CollectionUtils;
import com.hazelcast.jet.nonapi.io.github.classgraph.utils.LogNode;
import com.hazelcast.jet.nonapi.io.github.classgraph.utils.ReflectionUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class ModuleFinder {
    private List<ModuleRef> systemModuleRefs;
    private List<ModuleRef> nonSystemModuleRefs;

    public List<ModuleRef> getSystemModuleRefs() {
        return this.systemModuleRefs;
    }

    public List<ModuleRef> getNonSystemModuleRefs() {
        return this.nonSystemModuleRefs;
    }

    private static void findLayerOrder(Object layer, Set<Object> layerVisited, Set<Object> parentLayers, Deque<Object> layerOrderOut) {
        if (layerVisited.add(layer)) {
            List parents = (List)ReflectionUtils.invokeMethod(layer, "parents", true);
            if (parents != null) {
                parentLayers.addAll(parents);
                for (Object parent : parents) {
                    ModuleFinder.findLayerOrder(parent, layerVisited, parentLayers, layerOrderOut);
                }
            }
            layerOrderOut.push(layer);
        }
    }

    private static List<ModuleRef> findModuleRefs(LinkedHashSet<Object> layers, ScanSpec scanSpec, LogNode log) {
        ArrayList<Object> layerOrderFinal;
        if (layers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayDeque<Object> layerOrder = new ArrayDeque<Object>();
        HashSet<Object> parentLayers = new HashSet<Object>();
        for (Object layer : layers) {
            ModuleFinder.findLayerOrder(layer, new HashSet<Object>(), parentLayers, layerOrder);
        }
        if (scanSpec.addedModuleLayers != null) {
            for (Object layer : scanSpec.addedModuleLayers) {
                ModuleFinder.findLayerOrder(layer, new HashSet<Object>(), parentLayers, layerOrder);
            }
        }
        if (scanSpec.ignoreParentModuleLayers) {
            layerOrderFinal = new ArrayList();
            for (Object e : layerOrder) {
                if (parentLayers.contains(e)) continue;
                layerOrderFinal.add(e);
            }
        } else {
            layerOrderFinal = new ArrayList<Object>(layerOrder);
        }
        HashSet<Object> addedModules = new HashSet<Object>();
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (Object e : layerOrderFinal) {
            Set modules;
            Object configuration = ReflectionUtils.invokeMethod(e, "configuration", true);
            if (configuration == null || (modules = (Set)ReflectionUtils.invokeMethod(configuration, "modules", true)) == null) continue;
            ArrayList<ModuleRef> modulesInLayer = new ArrayList<ModuleRef>();
            for (Object module : modules) {
                Object moduleReference = ReflectionUtils.invokeMethod(module, "reference", true);
                if (moduleReference == null || !addedModules.add(moduleReference)) continue;
                try {
                    modulesInLayer.add(new ModuleRef(moduleReference, e));
                }
                catch (IllegalArgumentException e2) {
                    if (log == null) continue;
                    log.log("Exception while creating ModuleRef for module " + moduleReference, e2);
                }
            }
            CollectionUtils.sortIfNotEmpty(modulesInLayer);
            linkedHashSet.addAll(modulesInLayer);
        }
        return new ArrayList<ModuleRef>(linkedHashSet);
    }

    private static List<ModuleRef> findModuleRefsFromCallstack(Class<?>[] callStack, ScanSpec scanSpec, LogNode log) {
        Object bootLayer;
        LinkedHashSet<Object> layers = new LinkedHashSet<Object>();
        if (callStack != null) {
            for (Class<?> stackFrameClass : callStack) {
                Object layer;
                Object module = ReflectionUtils.invokeMethod(stackFrameClass, "getModule", false);
                if (module == null || (layer = ReflectionUtils.invokeMethod(module, "getLayer", true)) == null) continue;
                layers.add(layer);
            }
        }
        Class<?> moduleLayerClass = null;
        try {
            moduleLayerClass = Class.forName("java.lang.ModuleLayer");
        }
        catch (ClassNotFoundException | LinkageError throwable) {
            // empty catch block
        }
        if (moduleLayerClass != null && (bootLayer = ReflectionUtils.invokeStaticMethod(moduleLayerClass, "boot", false)) != null) {
            layers.add(bootLayer);
        }
        return ModuleFinder.findModuleRefs(layers, scanSpec, log);
    }

    public ModuleFinder(Class<?>[] callStack, ScanSpec scanSpec, LogNode log) {
        boolean disableModules;
        boolean bl = disableModules = scanSpec.overrideClassLoaders != null || scanSpec.overrideClasspath != null;
        if (!disableModules) {
            List<ModuleRef> allModuleRefsList = null;
            if (scanSpec.overrideModuleLayers == null) {
                if (callStack != null && callStack.length > 0) {
                    allModuleRefsList = ModuleFinder.findModuleRefsFromCallstack(callStack, scanSpec, log);
                }
            } else {
                if (log != null) {
                    LogNode subLog = log.log("Overriding module layers");
                    for (Object moduleLayer : scanSpec.overrideModuleLayers) {
                        subLog.log(moduleLayer.toString());
                    }
                }
                allModuleRefsList = ModuleFinder.findModuleRefs(new LinkedHashSet<Object>(scanSpec.overrideModuleLayers), scanSpec, log);
            }
            if (allModuleRefsList != null) {
                this.systemModuleRefs = new ArrayList<ModuleRef>();
                this.nonSystemModuleRefs = new ArrayList<ModuleRef>();
                for (ModuleRef moduleRef : allModuleRefsList) {
                    if (moduleRef.isSystemModule()) {
                        this.systemModuleRefs.add(moduleRef);
                        continue;
                    }
                    this.nonSystemModuleRefs.add(moduleRef);
                }
            }
            if (log != null) {
                LogNode sysSubLog = log.log("Found system modules:");
                if (this.systemModuleRefs != null && !this.systemModuleRefs.isEmpty()) {
                    for (ModuleRef moduleRef : this.systemModuleRefs) {
                        sysSubLog.log(moduleRef.toString());
                    }
                } else {
                    sysSubLog.log("[None]");
                }
                LogNode logNode = log.log("Found non-system modules:");
                if (this.nonSystemModuleRefs != null && !this.nonSystemModuleRefs.isEmpty()) {
                    for (ModuleRef moduleRef : this.nonSystemModuleRefs) {
                        logNode.log(moduleRef.toString());
                    }
                } else {
                    logNode.log("[None]");
                }
            }
        } else if (log != null) {
            log.log("Module scanning is disabled, because classloaders or classpath was overridden");
        }
    }
}

