/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hazelcast.client.deployment;

import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.impl.ClientExtension;
import com.hazelcast.client.impl.spi.ClientProxyFactory;
import com.hazelcast.cluster.MembershipListener;
import com.hazelcast.collection.ItemListener;
import com.hazelcast.com.fasterxml.jackson.core.JsonFactory;
import com.hazelcast.config.EventJournalConfig;
import com.hazelcast.config.MerkleTreeConfig;
import com.hazelcast.config.replacer.EncryptionReplacer;
import com.hazelcast.config.replacer.PropertyReplacer;
import com.hazelcast.config.replacer.spi.ConfigReplacer;
import com.hazelcast.config.security.StaticCredentialsFactory;
import com.hazelcast.core.EntryListener;
import com.hazelcast.internal.config.DomConfigHelper;
import com.hazelcast.internal.util.ICMPHelper;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.nio.SocketInterceptor;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.ssl.BasicSSLContextFactory;
import com.hazelcast.nio.ssl.SSLContextFactory;
import com.hazelcast.partition.MigrationListener;
import com.hazelcast.security.ICredentialsFactory;
import com.hazelcast.spi.discovery.DiscoveryStrategyFactory;
import com.hazelcast.topic.MessageListener;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyIgnoreWarningBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeReinitializedClassBuildItem;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.hazelcast.client.deployment.HazelcastClientConfiguredBuildItem;
import io.quarkus.hazelcast.client.runtime.HazelcastClientBytecodeRecorder;
import io.quarkus.hazelcast.client.runtime.HazelcastClientConfig;
import io.quarkus.hazelcast.client.runtime.HazelcastClientProducer;
import java.io.IOException;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

class HazelcastClientProcessor {
    HazelcastClientProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem("hazelcast-client");
    }

    @BuildStep
    void enableSSL(BuildProducer<ExtensionSslNativeSupportBuildItem> ssl) {
        ssl.produce((BuildItem)new ExtensionSslNativeSupportBuildItem("hazelcast-client"));
    }

    @BuildStep
    void registerServiceProviders(BuildProducer<GeneratedResourceBuildItem> generatedResources, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<NativeImageResourceBuildItem> resources) throws IOException {
        this.registerServiceProviders(DiscoveryStrategyFactory.class, resources, reflectiveClasses, generatedResources);
        this.registerServiceProviders(ClientExtension.class, resources, reflectiveClasses, generatedResources);
        this.registerServiceProviders(JsonFactory.class, resources, reflectiveClasses, generatedResources);
    }

    @BuildStep
    void setup(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(HazelcastClientProducer.class));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    HazelcastClientConfiguredBuildItem resolveClientProperties(HazelcastClientBytecodeRecorder recorder, HazelcastClientConfig config) {
        recorder.configureRuntimeProperties(config);
        return new HazelcastClientConfiguredBuildItem();
    }

    @BuildStep
    void registerConfigurationFiles(BuildProducer<NativeImageResourceBuildItem> resources, BuildProducer<HotDeploymentWatchedFileBuildItem> watchedFiles) {
        resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"hazelcast-client.yml", "hazelcast-client-default.xml", "hazelcast-client.yaml", "hazelcast-client.xml"}));
        watchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem("hazelcast-client.yml"));
        watchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem("hazelcast-client.yaml"));
        watchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem("hazelcast-client.xml"));
    }

    @BuildStep
    void registerReflectivelyCreatedClasses(BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new Class[]{HazelcastClientCachingProvider.class, DomConfigHelper.class, EventJournalConfig.class, MerkleTreeConfig.class}));
    }

    @BuildStep
    void registerCustomImplementationClasses(BuildProducer<ReflectiveHierarchyBuildItem> reflectiveClassHierarchies, BuildProducer<ReflectiveHierarchyIgnoreWarningBuildItem> ignoreWarnings) {
        HazelcastClientProcessor.registerTypeHierarchy(reflectiveClassHierarchies, ignoreWarnings, SocketInterceptor.class, MembershipListener.class, MigrationListener.class, EntryListener.class, MessageListener.class, ItemListener.class, MapListener.class, ClientExtension.class, ClientProxyFactory.class);
    }

    @BuildStep
    void registerCustomConfigReplacerClasses(BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveClassHierarchies, BuildProducer<ReflectiveHierarchyIgnoreWarningBuildItem> ignoreWarnings) {
        HazelcastClientProcessor.registerTypeHierarchy(reflectiveClassHierarchies, ignoreWarnings, ConfigReplacer.class);
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new Class[]{EncryptionReplacer.class, PropertyReplacer.class}));
    }

    void registerServiceProviders(Class<?> klass, BuildProducer<NativeImageResourceBuildItem> resources, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<GeneratedResourceBuildItem> generatedResources) throws IOException {
        String service = "META-INF/services/" + klass.getName();
        for (String impl : ServiceUtil.classNamesNamedIn((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)service)) {
            reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{impl}));
        }
        resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{service}));
    }

    @BuildStep
    void registerCustomCredentialFactories(BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveClassHierarchies, BuildProducer<ReflectiveHierarchyIgnoreWarningBuildItem> ignoreWarnings) {
        HazelcastClientProcessor.registerTypeHierarchy(reflectiveClassHierarchies, ignoreWarnings, ICredentialsFactory.class);
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new Class[]{StaticCredentialsFactory.class}));
    }

    @BuildStep
    void registerSSLUtilities(BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveClassHierarchies, BuildProducer<ReflectiveHierarchyIgnoreWarningBuildItem> ignoreWarnings) {
        HazelcastClientProcessor.registerTypeHierarchy(reflectiveClassHierarchies, ignoreWarnings, SSLContextFactory.class);
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new Class[]{BasicSSLContextFactory.class}));
    }

    @BuildStep
    void registerUserImplementationsOfSerializableUtilities(BuildProducer<ReflectiveHierarchyBuildItem> reflectiveClassHierarchies, BuildProducer<ReflectiveHierarchyIgnoreWarningBuildItem> ignoreWarnings) {
        HazelcastClientProcessor.registerTypeHierarchy(reflectiveClassHierarchies, ignoreWarnings, DataSerializable.class, DataSerializableFactory.class, PortableFactory.class, Serializer.class);
    }

    @BuildStep
    void registerICMPHelper(BuildProducer<NativeImageResourceBuildItem> resources, BuildProducer<RuntimeReinitializedClassBuildItem> reinitializedClasses) {
        resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"lib/linux-x86/libicmp_helper.so", "lib/linux-x86_64/libicmp_helper.so"}));
        reinitializedClasses.produce((BuildItem)new RuntimeReinitializedClassBuildItem(ICMPHelper.class.getName()));
    }

    @BuildStep
    void registerXMLParsingUtilities(BuildProducer<NativeImageResourceBuildItem> resources) {
        resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"hazelcast-client-config-4.0.xsd"}));
    }

    private static void registerTypeHierarchy(BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchyClass, BuildProducer<ReflectiveHierarchyIgnoreWarningBuildItem> ignoreWarnings, Class<?> ... classNames) {
        for (Class<?> klass : classNames) {
            DotName simpleName = DotName.createSimple((String)klass.getName());
            reflectiveHierarchyClass.produce((BuildItem)new ReflectiveHierarchyBuildItem(Type.create((DotName)simpleName, (Type.Kind)Type.Kind.CLASS)));
            ignoreWarnings.produce((BuildItem)new ReflectiveHierarchyIgnoreWarningBuildItem(simpleName));
        }
    }
}

