/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hazelcast.client.deployment;

import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.config.ClientFlakeIdGeneratorConfig;
import com.hazelcast.client.config.ClientReliableTopicConfig;
import com.hazelcast.client.impl.ClientExtension;
import com.hazelcast.client.impl.protocol.task.topic.TopicAddMessageListenerMessageTask;
import com.hazelcast.client.impl.proxy.ClientCardinalityEstimatorProxy;
import com.hazelcast.client.impl.proxy.ClientClusterProxy;
import com.hazelcast.client.impl.proxy.ClientDurableExecutorServiceProxy;
import com.hazelcast.client.impl.proxy.ClientExecutorServiceProxy;
import com.hazelcast.client.impl.proxy.ClientFlakeIdGeneratorProxy;
import com.hazelcast.client.impl.proxy.ClientListProxy;
import com.hazelcast.client.impl.proxy.ClientMapProxy;
import com.hazelcast.client.impl.proxy.ClientMultiMapProxy;
import com.hazelcast.client.impl.proxy.ClientPNCounterProxy;
import com.hazelcast.client.impl.proxy.ClientQueueProxy;
import com.hazelcast.client.impl.proxy.ClientReliableMessageRunner;
import com.hazelcast.client.impl.proxy.ClientReliableTopicProxy;
import com.hazelcast.client.impl.proxy.ClientReplicatedMapProxy;
import com.hazelcast.client.impl.proxy.ClientRingbufferProxy;
import com.hazelcast.client.impl.proxy.ClientScheduledExecutorProxy;
import com.hazelcast.client.impl.proxy.ClientScheduledFutureProxy;
import com.hazelcast.client.impl.proxy.ClientSetProxy;
import com.hazelcast.client.impl.proxy.ClientTopicProxy;
import com.hazelcast.client.impl.spi.ClientProxyFactory;
import com.hazelcast.client.util.RandomLB;
import com.hazelcast.cluster.MembershipListener;
import com.hazelcast.collection.ItemListener;
import com.hazelcast.com.fasterxml.jackson.core.JsonFactory;
import com.hazelcast.config.replacer.EncryptionReplacer;
import com.hazelcast.config.replacer.PropertyReplacer;
import com.hazelcast.config.replacer.spi.ConfigReplacer;
import com.hazelcast.config.security.StaticCredentialsFactory;
import com.hazelcast.core.EntryListener;
import com.hazelcast.internal.diagnostics.EventQueuePlugin;
import com.hazelcast.internal.diagnostics.OverloadedConnectionsPlugin;
import com.hazelcast.internal.networking.nio.NioThread;
import com.hazelcast.internal.util.ICMPHelper;
import com.hazelcast.internal.util.RandomPicker;
import com.hazelcast.internal.util.ThreadLocalRandomProvider;
import com.hazelcast.internal.util.executor.StripedExecutor;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.nio.SocketInterceptor;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.ssl.BasicSSLContextFactory;
import com.hazelcast.nio.ssl.SSLContextFactory;
import com.hazelcast.partition.MigrationListener;
import com.hazelcast.query.extractor.ValueExtractor;
import com.hazelcast.security.ICredentialsFactory;
import com.hazelcast.spi.discovery.DiscoveryStrategyFactory;
import com.hazelcast.topic.MessageListener;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyIgnoreWarningBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeReinitializedClassBuildItem;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.hazelcast.client.deployment.HazelcastClientConfiguredBuildItem;
import io.quarkus.hazelcast.client.runtime.HazelcastClientBytecodeRecorder;
import io.quarkus.hazelcast.client.runtime.HazelcastClientConfig;
import io.quarkus.hazelcast.client.runtime.HazelcastClientProducer;
import java.io.IOException;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

class HazelcastClientProcessor {
    HazelcastClientProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem("hazelcast-client");
    }

    @BuildStep
    void enableSSL(BuildProducer<ExtensionSslNativeSupportBuildItem> ssl) {
        ssl.produce((BuildItem)new ExtensionSslNativeSupportBuildItem("hazelcast-client"));
    }

    @BuildStep
    void registerServiceProviders(BuildProducer<GeneratedResourceBuildItem> generatedResources, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<NativeImageResourceBuildItem> resources) throws IOException {
        this.registerServiceProviders(DiscoveryStrategyFactory.class, resources, reflectiveClasses, generatedResources);
        this.registerServiceProviders(ClientExtension.class, resources, reflectiveClasses, generatedResources);
        this.registerServiceProviders(JsonFactory.class, resources, reflectiveClasses, generatedResources);
    }

    @BuildStep
    void setup(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(HazelcastClientProducer.class));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    HazelcastClientConfiguredBuildItem resolveClientProperties(HazelcastClientBytecodeRecorder recorder, HazelcastClientConfig config) {
        recorder.configureRuntimeProperties(config);
        return new HazelcastClientConfiguredBuildItem();
    }

    @BuildStep
    void registerConfigurationFiles(BuildProducer<NativeImageResourceBuildItem> resources, BuildProducer<HotDeploymentWatchedFileBuildItem> watchedFiles) {
        resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"hazelcast-client.yml", "hazelcast-client-default.xml", "hazelcast-client.yaml", "hazelcast-client.xml"}));
        watchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem("hazelcast-client.yml"));
        watchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem("hazelcast-client.yaml"));
        watchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem("hazelcast-client.xml"));
    }

    @BuildStep
    void registerReflectivelyCreatedClasses(BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{HazelcastClientCachingProvider.class}).build());
    }

    @BuildStep
    void registerCustomImplementationClasses(BuildProducer<ReflectiveHierarchyBuildItem> reflectiveClassHierarchies, BuildProducer<ReflectiveHierarchyIgnoreWarningBuildItem> ignoreWarnings) {
        HazelcastClientProcessor.registerTypeHierarchy(reflectiveClassHierarchies, ignoreWarnings, SocketInterceptor.class, MembershipListener.class, MigrationListener.class, EntryListener.class, MessageListener.class, ItemListener.class, MapListener.class, ValueExtractor.class, ClientExtension.class, ClientProxyFactory.class);
    }

    @BuildStep
    void registerCustomConfigReplacerClasses(BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveClassHierarchies, BuildProducer<ReflectiveHierarchyIgnoreWarningBuildItem> ignoreWarnings) {
        HazelcastClientProcessor.registerTypeHierarchy(reflectiveClassHierarchies, ignoreWarnings, ConfigReplacer.class);
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{EncryptionReplacer.class, PropertyReplacer.class}).build());
    }

    void registerServiceProviders(Class<?> klass, BuildProducer<NativeImageResourceBuildItem> resources, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<GeneratedResourceBuildItem> generatedResources) throws IOException {
        String service = "META-INF/services/" + klass.getName();
        for (String impl : ServiceUtil.classNamesNamedIn((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)service)) {
            reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{impl}).build());
        }
        resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{service}));
    }

    @BuildStep
    void registerCustomCredentialFactories(BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveClassHierarchies, BuildProducer<ReflectiveHierarchyIgnoreWarningBuildItem> ignoreWarnings) {
        HazelcastClientProcessor.registerTypeHierarchy(reflectiveClassHierarchies, ignoreWarnings, ICredentialsFactory.class);
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{StaticCredentialsFactory.class}).build());
    }

    @BuildStep
    void registerDataStructureProxies(BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveClassHierarchies, BuildProducer<ReflectiveHierarchyIgnoreWarningBuildItem> ignoreWarnings) {
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{ClientSetProxy.class}).methods().build());
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{ClientQueueProxy.class}).methods().build());
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{ClientCardinalityEstimatorProxy.class}).methods().build());
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{ClientClusterProxy.class}).methods().build());
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{ClientDurableExecutorServiceProxy.class}).methods().build());
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{ClientExecutorServiceProxy.class}).methods().build());
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{ClientFlakeIdGeneratorProxy.class}).methods().build());
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{ClientListProxy.class}).methods().build());
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{ClientMapProxy.class}).methods().build());
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{ClientMultiMapProxy.class}).methods().build());
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{ClientPNCounterProxy.class}).methods().build());
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{ClientQueueProxy.class}).methods().build());
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{ClientReliableMessageRunner.class}).methods().build());
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{ClientReliableTopicProxy.class}).methods().build());
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{ClientReplicatedMapProxy.class}).methods().build());
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{ClientRingbufferProxy.class}).methods().build());
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{ClientScheduledExecutorProxy.class}).methods().build());
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{ClientScheduledFutureProxy.class}).methods().build());
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{ClientTopicProxy.class}).methods().build());
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{ClientReliableTopicConfig.class}).methods().build());
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{ClientFlakeIdGeneratorConfig.class}).methods().build());
        HazelcastClientProcessor.registerTypeHierarchy(reflectiveClassHierarchies, ignoreWarnings, RuntimeException.class);
    }

    @BuildStep
    void registerSSLUtilities(BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveClassHierarchies, BuildProducer<ReflectiveHierarchyIgnoreWarningBuildItem> ignoreWarnings) {
        HazelcastClientProcessor.registerTypeHierarchy(reflectiveClassHierarchies, ignoreWarnings, SSLContextFactory.class);
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{BasicSSLContextFactory.class}).build());
    }

    @BuildStep
    void registerUserImplementationsOfSerializableUtilities(BuildProducer<ReflectiveHierarchyBuildItem> reflectiveClassHierarchies, BuildProducer<ReflectiveHierarchyIgnoreWarningBuildItem> ignoreWarnings) {
        HazelcastClientProcessor.registerTypeHierarchy(reflectiveClassHierarchies, ignoreWarnings, DataSerializable.class, DataSerializableFactory.class, PortableFactory.class, Serializer.class);
    }

    @BuildStep
    void registerICMPHelper(BuildProducer<NativeImageResourceBuildItem> resources, BuildProducer<RuntimeReinitializedClassBuildItem> reinitializedClasses) {
        resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"lib/linux-x86/libicmp_helper.so", "lib/linux-x86_64/libicmp_helper.so"}));
        reinitializedClasses.produce((BuildItem)new RuntimeReinitializedClassBuildItem(ICMPHelper.class.getName()));
    }

    @BuildStep
    void initializeRandomHolderAtRuntime(BuildProducer<RuntimeInitializedClassBuildItem> runtimeInitializedClasses) {
        try {
            Class.forName("com.hazelcast.client.impl.connection.nio.WaitStrategy");
            runtimeInitializedClasses.produce((BuildItem)new RuntimeInitializedClassBuildItem("com.hazelcast.client.impl.connection.nio.WaitStrategy"));
        }
        catch (Throwable e) {
            runtimeInitializedClasses.produce((BuildItem)new RuntimeInitializedClassBuildItem("com.hazelcast.client.impl.connection.tcp.WaitStrategy"));
        }
        runtimeInitializedClasses.produce((BuildItem)new RuntimeInitializedClassBuildItem(TopicAddMessageListenerMessageTask.class.getName()));
        runtimeInitializedClasses.produce((BuildItem)new RuntimeInitializedClassBuildItem(ClientDurableExecutorServiceProxy.class.getName()));
        runtimeInitializedClasses.produce((BuildItem)new RuntimeInitializedClassBuildItem(ClientExecutorServiceProxy.class.getName()));
        runtimeInitializedClasses.produce((BuildItem)new RuntimeInitializedClassBuildItem(RandomLB.class.getName()));
        runtimeInitializedClasses.produce((BuildItem)new RuntimeInitializedClassBuildItem(EventQueuePlugin.class.getName()));
        runtimeInitializedClasses.produce((BuildItem)new RuntimeInitializedClassBuildItem(OverloadedConnectionsPlugin.class.getName()));
        runtimeInitializedClasses.produce((BuildItem)new RuntimeInitializedClassBuildItem(NioThread.class.getName()));
        runtimeInitializedClasses.produce((BuildItem)new RuntimeInitializedClassBuildItem(StripedExecutor.class.getName()));
        runtimeInitializedClasses.produce((BuildItem)new RuntimeInitializedClassBuildItem(ThreadLocalRandomProvider.class.getName()));
        runtimeInitializedClasses.produce((BuildItem)new RuntimeInitializedClassBuildItem(RandomPicker.class.getName()));
    }

    @BuildStep
    void registerXMLParsingUtilities(BuildProducer<NativeImageResourceBuildItem> resources) {
        resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"hazelcast-client-config-5.0.xsd"}));
        resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"hazelcast-client-config-5.1.xsd"}));
        resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"hazelcast-client-config-5.2.xsd"}));
    }

    private static void registerTypeHierarchy(BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchyClass, BuildProducer<ReflectiveHierarchyIgnoreWarningBuildItem> ignoreWarnings, Class<?> ... classNames) {
        for (Class<?> klass : classNames) {
            DotName simpleName = DotName.createSimple((String)klass.getName());
            reflectiveHierarchyClass.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type(Type.create((DotName)simpleName, (Type.Kind)Type.Kind.CLASS)).build());
            ignoreWarnings.produce((BuildItem)new ReflectiveHierarchyIgnoreWarningBuildItem(simpleName));
        }
    }
}

