/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hazelcast.client.runtime.graal;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.logging.ILogger;
import io.quarkus.hazelcast.client.runtime.graal.Target_ServiceDefinition;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

final class ServiceLoaderUtils {
    private ServiceLoaderUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Set<Target_ServiceDefinition> parse(URL url, ClassLoader classLoader, ILogger logger) {
        try {
            HashSet<Target_ServiceDefinition> names = new HashSet<Target_ServiceDefinition>();
            BufferedReader r = null;
            try {
                String line;
                r = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
                while ((line = r.readLine()) != null) {
                    String name;
                    int comment = line.indexOf(35);
                    if (comment >= 0) {
                        line = line.substring(0, comment);
                    }
                    if ((name = line.trim()).length() == 0) continue;
                    names.add(new Target_ServiceDefinition(name, classLoader));
                }
            }
            catch (Throwable throwable) {
                IOUtil.closeResource(r);
                throw throwable;
            }
            IOUtil.closeResource((Closeable)r);
            return names;
        }
        catch (Exception e) {
            logger.severe((Throwable)e);
            return Collections.emptySet();
        }
    }

    static ClassLoader resolveClassloader(ClassLoader classLoader) {
        return classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader;
    }
}

