/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hazelcast.client.runtime.graal;

import com.hazelcast.internal.util.ServiceLoader;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import io.quarkus.hazelcast.client.runtime.graal.ServiceLoaderUtils;
import io.quarkus.hazelcast.client.runtime.graal.Target_ServiceDefinition;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

@TargetClass(value=ServiceLoader.class)
public final class Target_ServiceLoader {
    @Alias
    private static ILogger LOGGER;

    @Substitute
    private static Set<Target_ServiceDefinition> getServiceDefinitions(String factoryId, ClassLoader classLoader) {
        ClassLoader actual = ServiceLoaderUtils.resolveClassloader(classLoader);
        HashSet<Target_ServiceDefinition> services = new HashSet<Target_ServiceDefinition>();
        try {
            Enumeration<URL> resources = actual.getResources("META-INF/services/" + factoryId);
            while (resources.hasMoreElements()) {
                services.addAll(ServiceLoaderUtils.parse(resources.nextElement(), actual, LOGGER));
            }
        }
        catch (IOException e) {
            LOGGER.severe((Throwable)e);
        }
        if (services.isEmpty()) {
            Logger.getLogger(ServiceLoader.class).finest("Service loader could not load 'META-INF/services/" + factoryId + "'. It may be empty or does not exist.");
        }
        return services;
    }
}

