/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hazelcast.client.runtime;

import com.hazelcast.client.config.ClientConfig;
import io.quarkus.hazelcast.client.runtime.HazelcastClientConfig;

class HazelcastConfigurationParser {
    HazelcastConfigurationParser() {
    }

    ClientConfig fromApplicationProperties(HazelcastClientConfig config, ClientConfig clientConfig) {
        this.setClusterName(clientConfig, config);
        this.setClusterAddress(clientConfig, config);
        this.setLabels(clientConfig, config);
        this.setOutboundPorts(clientConfig, config);
        this.setOutboundPortDefinitions(clientConfig, config);
        this.setConnectionTimeout(clientConfig, config);
        return clientConfig;
    }

    private void setClusterAddress(ClientConfig clientConfig, HazelcastClientConfig config) {
        if (config.clusterMembers.isPresent()) {
            for (String clusterMember : config.clusterMembers.get()) {
                clientConfig.getNetworkConfig().addAddress(new String[]{clusterMember});
            }
        }
    }

    private void setClusterName(ClientConfig clientConfig, HazelcastClientConfig config) {
        config.clusterName.ifPresent(arg_0 -> ((ClientConfig)clientConfig).setClusterName(arg_0));
    }

    private void setLabels(ClientConfig clientConfig, HazelcastClientConfig config) {
        if (config.labels.isPresent()) {
            for (String label : config.labels.get()) {
                clientConfig.addLabel(label);
            }
        }
    }

    private void setConnectionTimeout(ClientConfig clientConfig, HazelcastClientConfig config) {
        if (config.connectionTimeout.isPresent()) {
            int timeout = config.connectionTimeout.getAsInt();
            clientConfig.getNetworkConfig().setConnectionTimeout(timeout);
        }
    }

    private void setOutboundPortDefinitions(ClientConfig clientConfig, HazelcastClientConfig config) {
        if (config.outboundPortDefinitions.isPresent()) {
            for (String outboundPortDefinition : config.outboundPortDefinitions.get()) {
                clientConfig.getNetworkConfig().addOutboundPortDefinition(outboundPortDefinition);
            }
        }
    }

    private void setOutboundPorts(ClientConfig clientConfig, HazelcastClientConfig config) {
        if (config.outboundPorts.isPresent()) {
            for (Integer outboundPort : config.outboundPorts.get()) {
                clientConfig.getNetworkConfig().addOutboundPort(outboundPort.intValue());
            }
        }
    }
}

