/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hazelcast.repository.config;

import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.data.hazelcast.HazelcastKeyValueAdapter;
import org.springframework.data.keyvalue.core.KeyValueTemplate;
import org.springframework.data.keyvalue.repository.config.KeyValueRepositoryConfigurationExtension;
import org.springframework.data.repository.config.RepositoryConfigurationSource;

class HazelcastRepositoryConfigurationExtension
extends KeyValueRepositoryConfigurationExtension {
    private static final String HAZELCAST_ADAPTER_BEAN_NAME = "hazelcastKeyValueAdapter";

    HazelcastRepositoryConfigurationExtension() {
    }

    public String getModuleName() {
        return "Hazelcast";
    }

    protected String getModulePrefix() {
        return "hazelcast";
    }

    protected String getDefaultKeyValueTemplateRef() {
        return "keyValueTemplate";
    }

    public void registerBeansForRoot(BeanDefinitionRegistry registry, RepositoryConfigurationSource configurationSource) {
        String hazelcastInstanceRef = (String)configurationSource.getAttribute("hazelcastInstanceRef").get();
        RootBeanDefinition hazelcastKeyValueAdapterDefinition = new RootBeanDefinition(HazelcastKeyValueAdapter.class);
        ConstructorArgumentValues constructorArgumentValuesForHazelcastKeyValueAdapter = new ConstructorArgumentValues();
        constructorArgumentValuesForHazelcastKeyValueAdapter.addIndexedArgumentValue(0, (Object)new RuntimeBeanReference(hazelcastInstanceRef));
        hazelcastKeyValueAdapterDefinition.setConstructorArgumentValues(constructorArgumentValuesForHazelcastKeyValueAdapter);
        HazelcastRepositoryConfigurationExtension.registerIfNotAlreadyRegistered((AbstractBeanDefinition)hazelcastKeyValueAdapterDefinition, (BeanDefinitionRegistry)registry, (String)HAZELCAST_ADAPTER_BEAN_NAME, (Object)configurationSource);
        super.registerBeansForRoot(registry, configurationSource);
    }

    protected AbstractBeanDefinition getDefaultKeyValueTemplateBeanDefinition(RepositoryConfigurationSource configurationSource) {
        RootBeanDefinition keyValueTemplateDefinition = new RootBeanDefinition(KeyValueTemplate.class);
        ConstructorArgumentValues constructorArgumentValuesForKeyValueTemplate = new ConstructorArgumentValues();
        constructorArgumentValuesForKeyValueTemplate.addIndexedArgumentValue(0, (Object)new RuntimeBeanReference(HAZELCAST_ADAPTER_BEAN_NAME));
        constructorArgumentValuesForKeyValueTemplate.addIndexedArgumentValue(1, (Object)new RuntimeBeanReference("keyValueMappingContext"));
        keyValueTemplateDefinition.setConstructorArgumentValues(constructorArgumentValuesForKeyValueTemplate);
        return keyValueTemplateDefinition;
    }
}

