/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hazelcast.repository.query;

import com.hazelcast.query.impl.getters.ReflectionHelper;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;

public class HazelcastPropertyComparator
implements Comparator<Map.Entry<?, ?>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String attributeName;
    private final int direction;

    public HazelcastPropertyComparator(String attributeName, boolean ascending) {
        this.attributeName = attributeName;
        this.direction = ascending ? 1 : -1;
    }

    @Override
    public int compare(Map.Entry<?, ?> o1, Map.Entry<?, ?> o2) {
        try {
            Object o1Field = ReflectionHelper.extractValue(o1.getValue(), (String)this.attributeName);
            Object o2Field = ReflectionHelper.extractValue(o2.getValue(), (String)this.attributeName);
            if (o1Field == o2Field) {
                return 0;
            }
            if (o1Field == null) {
                return this.direction;
            }
            if (o2Field == null) {
                return -1 * this.direction;
            }
            if (o1Field instanceof Comparable && o2Field instanceof Comparable) {
                return this.direction * ((Comparable)o1Field).compareTo(o2Field);
            }
        }
        catch (Exception ignore) {
            return 0;
        }
        return 0;
    }
}

