/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hazelcast.repository.query;

import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.Predicates;
import java.util.Collection;
import java.util.Iterator;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Sort;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Metrics;
import org.springframework.data.geo.Point;
import org.springframework.data.hazelcast.repository.query.GeoPredicate;
import org.springframework.data.keyvalue.core.query.KeyValueQuery;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.util.Assert;

public class HazelcastQueryCreator
extends AbstractQueryCreator<KeyValueQuery<Predicate<?, ?>>, Predicate<?, ?>> {
    private final int limit;

    public HazelcastQueryCreator(PartTree tree) {
        super(tree);
        Integer maxResults = tree.getMaxResults();
        this.limit = tree.isLimiting() && maxResults != null && maxResults > 0 ? maxResults : 0;
    }

    public HazelcastQueryCreator(PartTree tree, ParameterAccessor parameters) {
        super(tree, parameters);
        Integer maxResults = tree.getMaxResults();
        this.limit = tree.isLimiting() && maxResults != null && maxResults > 0 ? maxResults : 0;
    }

    protected Predicate<?, ?> create(Part part, Iterator<Object> iterator) {
        return this.from(part, iterator);
    }

    protected Predicate<?, ?> and(Part part, Predicate<?, ?> base, Iterator<Object> iterator) {
        Predicate<?, ?> criteria = this.from(part, iterator);
        return Predicates.and((Predicate[])new Predicate[]{base, criteria});
    }

    protected Predicate<?, ?> or(Predicate<?, ?> base, Predicate<?, ?> criteria) {
        return Predicates.or((Predicate[])new Predicate[]{base, criteria});
    }

    protected KeyValueQuery<Predicate<?, ?>> complete(Predicate<?, ?> criteria, Sort sort) {
        KeyValueQuery keyValueQuery = this.limit == 0 ? new KeyValueQuery(criteria) : new KeyValueQuery((Object)new PagingPredicate(criteria, this.limit));
        if (sort != null) {
            keyValueQuery.setSort(sort);
        }
        return keyValueQuery;
    }

    private Predicate<?, ?> from(Part part, Iterator<Comparable<?>> iterator) {
        String property = part.getProperty().toDotPath();
        Part.Type type = part.getType();
        boolean ignoreCase = this.ifIgnoreCase(part);
        switch (type) {
            case AFTER: 
            case GREATER_THAN: 
            case GREATER_THAN_EQUAL: 
            case BEFORE: 
            case LESS_THAN: 
            case LESS_THAN_EQUAL: 
            case BETWEEN: {
                return this.fromInequalityVariant(type, property, iterator);
            }
            case IS_NULL: 
            case IS_NOT_NULL: {
                return this.fromNullVariant(type, property);
            }
            case IN: 
            case NOT_IN: {
                return this.fromCollectionVariant(type, property, iterator);
            }
            case CONTAINING: 
            case NOT_CONTAINING: 
            case STARTING_WITH: 
            case ENDING_WITH: 
            case LIKE: 
            case NOT_LIKE: {
                return this.fromLikeVariant(type, ignoreCase, property, iterator);
            }
            case TRUE: 
            case FALSE: {
                return this.fromBooleanVariant(type, property);
            }
            case SIMPLE_PROPERTY: 
            case NEGATING_SIMPLE_PROPERTY: {
                return this.fromEqualityVariant(type, ignoreCase, property, iterator);
            }
            case REGEX: {
                return Predicates.regex((String)property, (String)iterator.next().toString());
            }
            case IS_EMPTY: 
            case IS_NOT_EMPTY: {
                return this.fromEmptyVariant(type, property);
            }
            case NEAR: 
            case WITHIN: {
                return this.fromGeoVariant(type, property, iterator);
            }
        }
        throw new InvalidDataAccessApiUsageException(String.format("Unsupported type '%s'", type));
    }

    private Predicate<?, ?> fromBooleanVariant(Part.Type type, String property) {
        switch (type) {
            case TRUE: {
                return Predicates.equal((String)property, (Comparable)Boolean.valueOf(true));
            }
            case FALSE: {
                return Predicates.equal((String)property, (Comparable)Boolean.valueOf(false));
            }
        }
        throw new InvalidDataAccessApiUsageException(String.format("Logic error for '%s' in query", type));
    }

    private Predicate<?, ?> fromCollectionVariant(Part.Type type, String property, Iterator<Comparable<?>> iterator) {
        switch (type) {
            case IN: {
                return Predicates.in((String)property, (Comparable[])this.collectToArray(type, iterator));
            }
            case NOT_IN: {
                return Predicates.not((Predicate)Predicates.in((String)property, (Comparable[])this.collectToArray(type, iterator)));
            }
        }
        throw new InvalidDataAccessApiUsageException(String.format("Logic error for '%s' in query", type));
    }

    private Predicate<?, ?> fromInequalityVariant(Part.Type type, String property, Iterator<Comparable<?>> iterator) {
        switch (type) {
            case AFTER: 
            case GREATER_THAN: {
                return Predicates.greaterThan((String)property, iterator.next());
            }
            case GREATER_THAN_EQUAL: {
                return Predicates.greaterEqual((String)property, iterator.next());
            }
            case BEFORE: 
            case LESS_THAN: {
                return Predicates.lessThan((String)property, iterator.next());
            }
            case LESS_THAN_EQUAL: {
                return Predicates.lessEqual((String)property, iterator.next());
            }
            case BETWEEN: {
                Comparable<?> first = iterator.next();
                Comparable<?> second = iterator.next();
                return Predicates.between((String)property, first, second);
            }
        }
        throw new InvalidDataAccessApiUsageException(String.format("Logic error for '%s' in query", type));
    }

    private Predicate<?, ?> fromNullVariant(Part.Type type, String property) {
        switch (type) {
            case IS_NULL: {
                return Predicates.equal((String)property, null);
            }
            case IS_NOT_NULL: {
                return Predicates.notEqual((String)property, null);
            }
        }
        throw new InvalidDataAccessApiUsageException(String.format("Logic error for '%s' in query", type));
    }

    private Predicate<?, ?> fromEqualityVariant(Part.Type type, boolean ignoreCase, String property, Iterator<Comparable<?>> iterator) {
        switch (type) {
            case SIMPLE_PROPERTY: {
                if (ignoreCase) {
                    return Predicates.ilike((String)property, (String)iterator.next().toString());
                }
                return Predicates.equal((String)property, iterator.next());
            }
            case NEGATING_SIMPLE_PROPERTY: {
                if (ignoreCase) {
                    return Predicates.not((Predicate)Predicates.ilike((String)property, (String)iterator.next().toString()));
                }
                return Predicates.notEqual((String)property, iterator.next());
            }
        }
        throw new InvalidDataAccessApiUsageException(String.format("Logic error for '%s' in query", type));
    }

    private Predicate<?, ?> fromLikeVariant(Part.Type type, boolean ignoreCase, String property, Iterator<Comparable<?>> iterator) {
        String likeExpression = iterator.next().toString();
        switch (type) {
            case CONTAINING: 
            case NOT_CONTAINING: {
                likeExpression = String.join((CharSequence)"", "%", likeExpression, "%");
                break;
            }
            case STARTING_WITH: {
                likeExpression = String.join((CharSequence)"", likeExpression, "%");
                break;
            }
            case ENDING_WITH: {
                likeExpression = String.join((CharSequence)"", "%", likeExpression);
                break;
            }
            case LIKE: 
            case NOT_LIKE: {
                break;
            }
            default: {
                throw new InvalidDataAccessApiUsageException(String.format("'%s' is not supported for LIKE style query", type));
            }
        }
        Predicate likePredicate = ignoreCase ? Predicates.ilike((String)property, (String)likeExpression) : Predicates.like((String)property, (String)likeExpression);
        return type.equals((Object)Part.Type.NOT_LIKE) || type.equals((Object)Part.Type.NOT_CONTAINING) ? Predicates.not((Predicate)likePredicate) : likePredicate;
    }

    private boolean ifIgnoreCase(Part part) {
        switch (part.shouldIgnoreCase()) {
            case ALWAYS: {
                Assert.state((boolean)this.canUpperCase(part.getProperty()), (String)String.format("Unable to ignore case of %s types, the property '%s' must reference a String", part.getProperty().getType().getName(), part.getProperty().getSegment()));
                return true;
            }
            case WHEN_POSSIBLE: {
                return this.canUpperCase(part.getProperty());
            }
        }
        return false;
    }

    private boolean canUpperCase(PropertyPath path) {
        return String.class.equals((Object)path.getType());
    }

    private boolean isCollection(Object item) {
        return Collection.class.isAssignableFrom(item.getClass());
    }

    private Comparable<?>[] collectToArray(Part.Type type, Iterator<Comparable<?>> iterator) {
        Comparable<?> item = iterator.next();
        Assert.state((boolean)this.isCollection(item), (String)String.format("%s requires collection of values", type));
        Collection itemcol = (Collection)((Object)item);
        return itemcol.toArray(new Comparable[0]);
    }

    private Predicate<?, ?> fromEmptyVariant(Part.Type type, String property) {
        switch (type) {
            case IS_EMPTY: {
                return Predicates.equal((String)property, (Comparable)((Object)""));
            }
            case IS_NOT_EMPTY: {
                return Predicates.notEqual((String)property, (Comparable)((Object)""));
            }
        }
        throw new InvalidDataAccessApiUsageException(String.format("Logic error for '%s' in query", type));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Predicate<?, ?> fromGeoVariant(Part.Type type, String property, Iterator<Comparable<?>> iterator) {
        Distance distance;
        Point point;
        Comparable<?> item = iterator.next();
        if (item instanceof Point) {
            point = (Point)item;
            if (!iterator.hasNext()) {
                throw new InvalidDataAccessApiUsageException("Expected to find distance value for geo query. Are you missing a parameter?");
            }
            Comparable<?> distObject = iterator.next();
            if (distObject instanceof Distance) {
                distance = (Distance)distObject;
            } else {
                if (!(distObject instanceof Number)) throw new InvalidDataAccessApiUsageException(String.format("Expected to find Distance or Numeric value for geo query but was %s.", distObject.getClass()));
                distance = new Distance(((Number)((Object)distObject)).doubleValue(), (Metric)Metrics.KILOMETERS);
            }
        } else {
            if (!(item instanceof Circle)) throw new InvalidDataAccessApiUsageException(String.format("Expected to find a Circle or Point/Distance for geo query but was %s.", item.getClass()));
            point = ((Circle)item).getCenter();
            distance = ((Circle)item).getRadius();
        }
        switch (type) {
            case NEAR: 
            case WITHIN: {
                return new GeoPredicate(property, point, distance);
            }
        }
        throw new InvalidDataAccessApiUsageException(String.format("Logic error for '%s' in query", type));
    }
}

