/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hazelcast.repository.support;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.predicates.SqlPredicate;
import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.data.hazelcast.repository.support.HazelcastQueryMethod;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;

public class StringBasedHazelcastRepositoryQuery
implements RepositoryQuery {
    private final HazelcastQueryMethod queryMethod;
    private final String keySpace;
    private final HazelcastInstance hazelcastInstance;

    public StringBasedHazelcastRepositoryQuery(HazelcastQueryMethod queryMethod, HazelcastInstance hazelcastInstance) {
        this.queryMethod = queryMethod;
        this.keySpace = queryMethod.getKeySpace();
        this.hazelcastInstance = hazelcastInstance;
    }

    public Object execute(Object[] parameters) {
        String queryStringTemplate = this.queryMethod.getAnnotatedQuery();
        String queryString = String.format(queryStringTemplate, this.formatParameters(parameters));
        SqlPredicate sqlPredicate = new SqlPredicate(queryString);
        return this.getMap(this.keySpace).values((Predicate)sqlPredicate);
    }

    private Object[] formatParameters(Object[] parameters) {
        Object[] result = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            result[i] = parameters[i] instanceof Collection ? StringBasedHazelcastRepositoryQuery.formatCollection((Collection)parameters[i]) : parameters[i];
        }
        return result;
    }

    private static String formatCollection(Collection<?> collection) {
        return String.format("(%s)", collection.stream().map(Object::toString).collect(Collectors.joining(",")));
    }

    private IMap getMap(String keySpace) {
        return this.hazelcastInstance.getMap(keySpace);
    }

    public QueryMethod getQueryMethod() {
        return this.queryMethod;
    }
}

