/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.cache;

import com.hb0730.commons.lang.thread.ThreadUtils;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PreDestroy;

public enum GlobalPruneTimer {
    INSTANCE;

    private final AtomicInteger cacheTaskNumber = new AtomicInteger(1);
    private ScheduledExecutorService pruneTimer;

    private GlobalPruneTimer() {
        this.create();
    }

    public ScheduledFuture<?> schedule(Runnable task, long delay) {
        return this.pruneTimer.scheduleAtFixedRate(task, delay, delay, TimeUnit.MILLISECONDS);
    }

    public void create() {
        if (null != this.pruneTimer) {
            this.shutdownNow();
        }
        this.pruneTimer = new ScheduledThreadPoolExecutor(1, r -> ThreadUtils.newThread((Runnable)r, (String)String.format("cache-prune-timer-%d", this.cacheTaskNumber.getAndIncrement())));
    }

    @PreDestroy
    public void shutdown() {
        if (null != this.pruneTimer) {
            this.pruneTimer.shutdown();
        }
    }

    public List<Runnable> shutdownNow() {
        if (null != this.pruneTimer) {
            return this.pruneTimer.shutdownNow();
        }
        return null;
    }
}

