/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.cache.impl;

import com.hb0730.commons.cache.Cache;
import com.hb0730.commons.cache.CacheWrapper;
import com.hb0730.commons.lang.collection.CollectionUtils;
import com.hb0730.commons.lang.date.DateMsUnit;
import com.hb0730.commons.lang.date.DateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public abstract class AbstractCache<K, V>
implements Cache<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCache.class);

    @Nonnull
    protected abstract Optional<CacheWrapper<V>> getInternal(@Nonnull K var1);

    @Nonnull
    protected abstract Optional<Map<K, CacheWrapper<V>>> getInternal(@Nonnull Set<K> var1);

    protected abstract void putInternal(@Nonnull K var1, @Nonnull CacheWrapper<V> var2);

    protected abstract Boolean putInternalIfAbsent(@Nonnull K var1, @Nonnull CacheWrapper<V> var2);

    @Override
    @Nonnull
    public Optional<V> get(@Nonnull K key) {
        Assert.notNull(key, (String)"Cache key must not be null");
        return this.getInternal(key).map(wrapper -> {
            if (wrapper.getExpireAt() != null && wrapper.getExpireAt().before(DateUtils.now())) {
                LOGGER.warn("Cache key: [{}] has been expired", key);
                this.delete(key);
                return null;
            }
            return wrapper.getData();
        });
    }

    @Override
    public Optional<List<V>> get(@Nonnull Set<K> keys) {
        Assert.notEmpty(keys, (String)"Cache key must not be null");
        ArrayList keyList = new ArrayList(keys.size());
        Optional<List<V>> result = this.getInternal(keys).map(map -> map.entrySet().stream().map(entry -> {
            CacheWrapper wrapper = (CacheWrapper)entry.getValue();
            if (wrapper.getExpireAt() != null && wrapper.getExpireAt().before(DateUtils.now())) {
                LOGGER.warn("Cache key: [{}] has been expired", entry.getKey());
                keyList.add(entry.getKey());
                return null;
            }
            return wrapper.getData();
        }).collect(Collectors.toList()));
        if (!CollectionUtils.isEmpty(keyList)) {
            this.delete(CollectionUtils.newHashSet(keyList));
        }
        return result;
    }

    @Override
    public void put(@Nonnull K key, @Nonnull V value, long timeout, @Nonnull TimeUnit timeUnit) {
        this.putInternal(key, this.buildCacheWrapper(value, timeout, timeUnit));
    }

    @Override
    public Boolean putIfAbsent(@Nonnull K key, @Nonnull V value, long timeout, @Nonnull TimeUnit timeUnit) {
        return this.putInternalIfAbsent(key, this.buildCacheWrapper(value, timeout, timeUnit));
    }

    @Override
    public void put(@Nonnull K key, @Nonnull V value) {
        this.putInternal(key, this.buildCacheWrapper(value, -1L, null));
    }

    private CacheWrapper<V> buildCacheWrapper(@Nonnull V value, Long timeout, @Nullable TimeUnit timeUnit) {
        Assert.notNull(value, (String)"cache value must not be null");
        Assert.isTrue((timeout >= -1L ? 1 : 0) != 0, (String)"cache expiration timout must not be less than 1");
        Date now = DateUtils.now();
        Date expireAt = null;
        if (timeout > 0L && timeUnit != null) {
            expireAt = DateUtils.add((Date)now, (long)timeout, (TimeUnit)timeUnit);
        } else if (timeout <= 0L) {
            expireAt = DateUtils.addYears((Date)now, (int)999);
        }
        CacheWrapper<V> cacheWrapper = new CacheWrapper<V>();
        cacheWrapper.setCreateAt(now);
        cacheWrapper.setExpireAt(expireAt);
        cacheWrapper.setData(value);
        return cacheWrapper;
    }

    protected long expireTimeMs(Date createAt, Date expireAt) {
        return DateUtils.between((Date)createAt, (Date)expireAt, (DateMsUnit)DateMsUnit.MS);
    }
}

