/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.cache.impl.remote;

import com.hb0730.commons.cache.CacheWrapper;
import com.hb0730.commons.cache.exception.CacheException;
import com.hb0730.commons.cache.impl.remote.AbstractRemoteCache;
import com.hb0730.commons.cache.support.redis.springdata.RedisSpringDataCacheConfig;
import com.hb0730.commons.cache.support.serial.Serializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.util.Assert;

public class RedisSpringDataCache<K, V>
extends AbstractRemoteCache<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisSpringDataCache.class);
    private final RedisConnectionFactory connectionFactory;
    private final Serializer serializer;

    public RedisSpringDataCache(RedisSpringDataCacheConfig<K, V> config) {
        super(config);
        this.connectionFactory = config.getConnectionFactory();
        this.serializer = config.getSerializer();
        Assert.notNull((Object)this.connectionFactory, (String)"connectionFactory is required");
    }

    @Override
    @Nonnull
    protected Optional<CacheWrapper<V>> getInternal(@Nonnull K key) {
        Assert.notNull(key, (String)"Cache key must not be null");
        RedisConnection connection = null;
        try {
            connection = this.connectionFactory.getConnection();
            byte[] newKey = this.buildKey(key);
            byte[] resultBytes = connection.get(newKey);
            if (resultBytes != null) {
                CacheWrapper result = (CacheWrapper)this.serializer.deserialize(resultBytes);
                LOGGER.debug("get success key:[{}],result:[{}]", key, (Object)result);
                Optional<CacheWrapper<V>> optional = Optional.ofNullable(result);
                return optional;
            }
            Optional<CacheWrapper<V>> optional = Optional.empty();
            return optional;
        }
        catch (Exception e) {
            LOGGER.error("get cache error key [{}], message:[{}]", key, (Object)e.getMessage());
            throw new CacheException("get cache error", e);
        }
        finally {
            this.closeConnection(connection);
        }
    }

    @Override
    @Nonnull
    protected Optional<Map<K, CacheWrapper<V>>> getInternal(@Nonnull Set<K> keys) {
        Assert.notEmpty(keys, (String)"Cache key must not be null");
        RedisConnection connection = null;
        try {
            connection = this.connectionFactory.getConnection();
            ArrayList<K> keyList = new ArrayList<K>(keys);
            byte[][] newKeys = (byte[][])keyList.stream().map(k -> {
                try {
                    return this.buildKey(k);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new CacheException("build key error");
                }
            }).toArray(x$0 -> new byte[x$0][]);
            HashMap<K, CacheWrapper> resultMap = new HashMap<K, CacheWrapper>();
            if (newKeys.length > 0) {
                List mgetResults = connection.mGet(newKeys);
                for (int i = 0; i < (mgetResults != null ? mgetResults.size() : 0); ++i) {
                    byte[] bytes = (byte[])mgetResults.get(i);
                    K k2 = keyList.get(i);
                    CacheWrapper result = (CacheWrapper)this.serializer.deserialize(bytes);
                    resultMap.put(k2, result);
                }
                Optional<Map<K, CacheWrapper<V>>> optional = Optional.of(resultMap);
                return optional;
            }
            Optional<Map<K, CacheWrapper<V>>> optional = Optional.empty();
            return optional;
        }
        catch (Exception e) {
            LOGGER.error("get cache error key [{}], message:[{}]", keys, (Object)e.getMessage());
            throw new CacheException("get cache error", e);
        }
        finally {
            this.closeConnection(connection);
        }
    }

    @Override
    protected void putInternal(@Nonnull K key, @Nonnull CacheWrapper<V> cacheWrapper) {
        Assert.notNull(key, (String)"Cache key must not be blank");
        Assert.notNull(cacheWrapper, (String)"Cache wrapper must not be null");
        RedisConnection connection = null;
        try {
            connection = this.connectionFactory.getConnection();
            byte[] keyByte = this.buildKey(key);
            byte[] valueBytes = this.serializer.serialize(cacheWrapper);
            assert (valueBytes != null);
            long expireAt = this.expireTimeMs(cacheWrapper.getCreateAt(), cacheWrapper.getExpireAt());
            connection.pSetEx(keyByte, expireAt, valueBytes);
            LOGGER.debug("put success then key [{}]", key);
        }
        catch (Exception e) {
            LOGGER.error("put cache error message:[{}]", (Object)e.getMessage(), (Object)e);
            throw new CacheException("put cache error", e);
        }
        finally {
            this.closeConnection(connection);
        }
    }

    @Override
    protected Boolean putInternalIfAbsent(@Nonnull K key, @Nonnull CacheWrapper<V> cacheWrapper) {
        Assert.notNull(key, (String)"Cache key must not be blank");
        Assert.notNull(cacheWrapper, (String)"Cache wrapper must not be null");
        RedisConnection connection = null;
        try {
            connection = this.connectionFactory.getConnection();
            byte[] newkey = this.buildKey(key);
            byte[] valueBytes = this.serializer.serialize(cacheWrapper);
            assert (valueBytes != null);
            long expireAt = this.expireTimeMs(cacheWrapper.getCreateAt(), cacheWrapper.getExpireAt());
            Boolean result = connection.set(newkey, valueBytes, Expiration.milliseconds((long)expireAt), RedisStringCommands.SetOption.ifAbsent());
            LOGGER.debug("put_is_absent success,then key [{}] result:[{}]", key, (Object)result);
            Boolean bl = result;
            return bl;
        }
        catch (Exception e) {
            LOGGER.error("put_if_absent cache error message:[{}]", (Object)e.getMessage(), (Object)e);
            throw new CacheException("put ifAbsent error", e);
        }
        finally {
            this.closeConnection(connection);
        }
    }

    @Override
    public void delete(@Nonnull K key) {
        Assert.notNull(key, (String)"Cache key must not be null");
        RedisConnection connection = null;
        try {
            byte[] keyByte = this.buildKey(key);
            connection = this.connectionFactory.getConnection();
            connection.del((byte[][])new byte[][]{keyByte});
            LOGGER.debug("delete success then key [{}]", key);
            this.closeConnection(connection);
        }
        catch (Exception e) {
            try {
                LOGGER.error("delete error message:[{}]", (Object)e.getMessage(), (Object)e);
                throw new CacheException("delete cache error", e);
            }
            catch (Throwable throwable) {
                this.closeConnection(connection);
                throw throwable;
            }
        }
    }

    @Override
    public void delete(@Nonnull Set<K> keys) {
        Assert.notEmpty(keys, (String)"Cache key must not be null");
        RedisConnection connection = null;
        try {
            connection = this.connectionFactory.getConnection();
            byte[][] newKeys = (byte[][])keys.stream().map(k -> {
                try {
                    return this.buildKey(k);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new CacheException("build key error", e);
                }
            }).toArray(len -> new byte[keys.size()][]);
            connection.del(newKeys);
            LOGGER.debug("delete success then key [{}]", keys);
        }
        catch (Exception e) {
            LOGGER.error("delete error message:[{}]", (Object)e.getMessage(), (Object)e);
            throw new CacheException("delete cache error", e);
        }
        finally {
            this.closeConnection(connection);
        }
    }

    private void closeConnection(RedisConnection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (Exception e) {
            LOGGER.error("RedisConnection close fail: {}, {}", (Object)e.getMessage(), (Object)e.getClass().getName());
        }
    }
}

