/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.cache.support.serial;

import com.hb0730.commons.cache.exception.CacheException;
import com.hb0730.commons.cache.support.serial.GlobalSerializeMap;
import com.hb0730.commons.cache.support.serial.Serializer;
import java.io.ByteArrayOutputStream;
import java.lang.ref.WeakReference;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractSerializer
implements Serializer {
    protected boolean useIdentityNumber;
    private static final int INIT_BUF_SIZE = 256;
    private final int identityNumber;
    private static ThreadLocal<WeakReference<ByteArrayOutputStream>> threadLocal = ThreadLocal.withInitial(() -> new WeakReference<ByteArrayOutputStream>(new ByteArrayOutputStream(256)));

    public AbstractSerializer(boolean useIdentityNumber, int identityNumber) {
        this.useIdentityNumber = useIdentityNumber;
        this.identityNumber = identityNumber;
    }

    @Nullable
    protected abstract byte[] doSerialize(@Nonnull ByteArrayOutputStream var1, @Nullable Object var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public byte[] serialize(@Nullable Object obj) throws Exception {
        if (obj == null) {
            return EMPTY_ARRAY;
        }
        WeakReference<ByteArrayOutputStream> ref = threadLocal.get();
        ByteArrayOutputStream bos = (ByteArrayOutputStream)ref.get();
        if (bos == null) {
            bos = new ByteArrayOutputStream(256);
            threadLocal.set(new WeakReference<ByteArrayOutputStream>(bos));
        }
        try {
            if (this.useIdentityNumber) {
                byte[] headerBuffer = new byte[4];
                this.writeHeader(headerBuffer, this.identityNumber);
                bos.write(headerBuffer);
            }
            byte[] byArray = this.doSerialize(bos, obj);
            return byArray;
        }
        finally {
            bos.reset();
        }
    }

    protected abstract Object doDeserialize(@Nullable byte[] var1) throws Exception;

    @Override
    @Nullable
    public Object deserialize(@Nullable byte[] buffer) throws Exception {
        if (buffer == null || 0 == buffer.length) {
            return null;
        }
        try {
            if (this.useIdentityNumber) {
                GlobalSerializeMap.register();
                int identityNumber = this.parseHeader(buffer);
                AbstractSerializer serializer = (AbstractSerializer)GlobalSerializeMap.get(identityNumber);
                Objects.requireNonNull(serializer, "no deserialize for identity number:" + identityNumber);
                return serializer.doDeserialize(buffer);
            }
            return this.doDeserialize(buffer);
        }
        catch (Exception e) {
            throw new CacheException("decode error", e);
        }
    }

    protected void writeHeader(byte[] buf, int header) {
        buf[0] = (byte)(header >> 24 & 0xFF);
        buf[1] = (byte)(header >> 16 & 0xFF);
        buf[2] = (byte)(header >> 8 & 0xFF);
        buf[3] = (byte)(header & 0xFF);
    }

    protected int parseHeader(byte[] buf) {
        int x = 0;
        x |= buf[0] & 0xFF;
        x <<= 8;
        x |= buf[1] & 0xFF;
        x <<= 8;
        x |= buf[2] & 0xFF;
        x <<= 8;
        return x |= buf[3] & 0xFF;
    }

    public boolean isUseIdentityNumber() {
        return this.useIdentityNumber;
    }

    public int getIdentityNumber() {
        return this.identityNumber;
    }
}

