/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.cache.support.serial;

import com.hb0730.commons.cache.exception.CacheException;
import com.hb0730.commons.cache.support.serial.Serializer;
import com.hb0730.commons.cache.support.serial.impl.Jackson2JsonCacheWrapperSerializer;
import com.hb0730.commons.cache.support.serial.impl.JdkCacheSerializer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.springframework.util.Assert;

public class GlobalSerializeMap {
    private static Map<Integer, Serializer> serializerMap;
    private static boolean isInit;

    public static void put(@Nonnull Integer identityNumber, Serializer serializer) {
        GlobalSerializeMap.putInternal(identityNumber, serializer);
    }

    private static synchronized void putInternal(@Nonnull Integer identityNumber, Serializer serializer) {
        Assert.notNull((Object)identityNumber, (String)"identity number must not be null");
        if (null == serializerMap) {
            serializerMap = new ConcurrentHashMap<Integer, Serializer>(16);
        } else if (null != serializerMap.get(identityNumber)) {
            throw new CacheException("identityNumber Already exists");
        }
        serializerMap.put(identityNumber, serializer);
    }

    public static Serializer get(Integer identityNumber) {
        if (null == serializerMap) {
            return null;
        }
        return serializerMap.get(identityNumber);
    }

    public static void register() {
        if (!isInit) {
            GlobalSerializeMap.put(1251293824, JdkCacheSerializer.INSTANCE);
            GlobalSerializeMap.put(1251293825, Jackson2JsonCacheWrapperSerializer.JSON_STRING_SERIALIZER);
            isInit = true;
        }
    }

    static {
        isInit = false;
    }
}

