/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.cache.support.serial.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.hb0730.commons.cache.CacheWrapper;
import com.hb0730.commons.cache.exception.CacheException;
import com.hb0730.commons.cache.support.serial.AbstractSerializer;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Jackson2JsonCacheWrapperSerializer
extends AbstractSerializer {
    public static final Jackson2JsonCacheWrapperSerializer JSON_STRING_SERIALIZER = new Jackson2JsonCacheWrapperSerializer(true);
    private final ObjectMapper objectMapper;
    public static final int IDENTITY_NUMBER = 1251293825;

    public Jackson2JsonCacheWrapperSerializer(boolean useIdentityNumber) {
        super(useIdentityNumber, 1251293825);
        this.objectMapper = new ObjectMapper();
    }

    public Jackson2JsonCacheWrapperSerializer(boolean useIdentityNumber, ObjectMapper objectMapper) {
        super(useIdentityNumber, 1251293825);
        this.objectMapper = objectMapper;
    }

    @Override
    protected Object doDeserialize(@Nullable byte[] buffer) throws Exception {
        if (null == buffer || 0 == buffer.length) {
            return null;
        }
        try {
            if (this.useIdentityNumber) {
                return this.getObjectMapper().readValue(buffer, 4, buffer.length - 4, CacheWrapper.class);
            }
            return this.getObjectMapper().readValue(buffer, CacheWrapper.class);
        }
        catch (Exception e) {
            throw new CacheException("jackson deserialize error:" + e.getMessage(), e);
        }
    }

    @Override
    protected byte[] doSerialize(@Nonnull ByteArrayOutputStream outStream, Object value) throws Exception {
        if (null == value) {
            return EMPTY_ARRAY;
        }
        this.getObjectMapper().writeValue((OutputStream)outStream, value);
        outStream.flush();
        return outStream.toByteArray();
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

