/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.cache.impl.local;

import com.hb0730.commons.cache.CacheWrapper;
import com.hb0730.commons.cache.exception.CacheException;
import com.hb0730.commons.cache.impl.AbstractCache;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class InMemoryCacheStore<K, V>
extends AbstractCache<K, V> {
    public static final Logger LOGGER = LoggerFactory.getLogger(InMemoryCacheStore.class);
    private Map<K, CacheWrapper<V>> cacheContainer;
    private final ReentrantReadWriteLock cacheLock = new ReentrantReadWriteLock(true);
    private final Lock writeLock = this.cacheLock.writeLock();
    private final Lock readLock = this.cacheLock.readLock();

    public InMemoryCacheStore() {
        this.cacheContainer = new ConcurrentHashMap<K, CacheWrapper<V>>();
    }

    public InMemoryCacheStore(Map<K, CacheWrapper<V>> cacheMap) {
        this.cacheContainer = null == cacheMap ? new ConcurrentHashMap<K, CacheWrapper<V>>() : cacheMap;
    }

    @Override
    @Nonnull
    public Optional<CacheWrapper<V>> getInternal(@Nonnull K key) {
        Assert.notNull(key, (String)"Cache key must not be blank");
        this.readLock.lock();
        try {
            Optional<CacheWrapper<V>> optional = Optional.ofNullable(this.cacheContainer.get(key));
            return optional;
        }
        catch (Exception e) {
            LOGGER.error("get error key [{}]", key, (Object)e);
            throw new CacheException("get cache error", e);
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    @Nonnull
    protected Optional<Map<K, CacheWrapper<V>>> getInternal(@Nonnull Set<K> keys) {
        Assert.notNull(keys, (String)"Cache key must not be blank");
        this.readLock.lock();
        try {
            HashMap<K, CacheWrapper<V>> result = new HashMap<K, CacheWrapper<V>>();
            for (K key : keys) {
                CacheWrapper<V> wrapper = this.cacheContainer.get(key);
                result.put(key, wrapper);
            }
            Optional optional = Optional.of(result);
            return optional;
        }
        catch (Exception e) {
            LOGGER.error("get error keys [{}]", keys, (Object)e);
            throw new CacheException("get cache error", e);
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void putInternal(@Nonnull K key, @Nonnull CacheWrapper<V> cacheWrapper) {
        Assert.notNull(key, (String)"Cache key  must  not be null");
        Assert.notNull(cacheWrapper, (String)"Cache wrapper must not be null");
        this.writeLock.lock();
        try {
            CacheWrapper<V> wrapper = this.cacheContainer.put(key, cacheWrapper);
            LOGGER.debug("put[{}] cache result:[{}],original  cache wrapper: [{}]", new Object[]{key, wrapper, cacheWrapper});
        }
        catch (Exception e) {
            LOGGER.error("put cache error", (Throwable)e);
            throw new CacheException("put cache error", e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Boolean putInternalIfAbsent(@Nonnull K key, @Nonnull CacheWrapper<V> cacheWrapper) {
        Assert.notNull(key, (String)"Cache key must  not be null");
        Assert.notNull(cacheWrapper, (String)"Cache wrapper must not be null");
        Optional valueOptional = this.get(key);
        if (valueOptional.isPresent()) {
            LOGGER.warn("Failed to put the cache, because the key: [{}] has been present already", key);
            return false;
        }
        this.putInternal(key, cacheWrapper);
        return true;
    }

    @Override
    public void delete(@Nonnull K key) {
        Assert.notNull(key, (String)"Cache key  must  not be null");
        this.writeLock.lock();
        try {
            this.cacheContainer.remove(key);
            LOGGER.debug("removed key [{}]", key);
        }
        catch (Exception e) {
            LOGGER.error("delete cache error", (Throwable)e);
            throw new CacheException("delete cache error", e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void delete(@Nonnull Set<K> keys) {
        Assert.notNull(keys, (String)"Cache key must  not be null");
        this.writeLock.lock();
        try {
            for (K key : keys) {
                this.cacheContainer.remove(key);
            }
        }
        catch (Exception e) {
            LOGGER.error("delete cache error", (Throwable)e);
            throw new CacheException("delete cache error", e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    @PreDestroy
    public void clearCache() {
        this.clear();
    }

    private void clear() {
        this.cacheContainer.clear();
    }
}

