/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.cache.impl.remote;

import com.hb0730.commons.cache.config.CacheConfig;
import com.hb0730.commons.cache.exception.CacheException;
import com.hb0730.commons.cache.impl.AbstractCache;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.util.Assert;

public abstract class AbstractRemoteCache<K, V>
extends AbstractCache<K, V> {
    protected CacheConfig<K, V> config;

    public AbstractRemoteCache(CacheConfig<K, V> config) {
        this.config = config;
    }

    protected byte[] buildKey(K key) throws CacheException, IOException {
        Object newKey = key;
        if (key instanceof byte[]) {
            newKey = key;
        } else if (key instanceof String) {
            newKey = key;
        } else if (this.config.getKeyConverter() != null) {
            newKey = this.config.getKeyConverter().apply(key);
        }
        return this.buildKeyForByte(newKey);
    }

    protected byte[] buildKeyForByte(Object key) throws CacheException, IOException {
        Assert.notNull((Object)key, (String)"key must not be null");
        byte[] keyBytesWithOutPrefix = null;
        if (key instanceof String) {
            keyBytesWithOutPrefix = key.toString().getBytes(StandardCharsets.UTF_8);
        } else if (key instanceof byte[]) {
            keyBytesWithOutPrefix = (byte[])key;
        } else if (key instanceof Number) {
            keyBytesWithOutPrefix = (key.getClass().getSimpleName() + key).getBytes(StandardCharsets.UTF_8);
        } else if (key instanceof Date) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss,SSS");
            keyBytesWithOutPrefix = (key.getClass().getSimpleName() + sdf.format(key)).getBytes();
        } else if (key instanceof Boolean) {
            keyBytesWithOutPrefix = key.toString().getBytes(StandardCharsets.UTF_8);
        } else if (key instanceof Serializable) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(bos);
            os.writeObject(key);
            os.close();
            bos.close();
            keyBytesWithOutPrefix = bos.toByteArray();
        } else {
            throw new CacheException("can't convert key of class:" + key.getClass());
        }
        return keyBytesWithOutPrefix;
    }
}

