/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.cache.impl.remote;

import com.hb0730.commons.cache.CacheWrapper;
import com.hb0730.commons.cache.exception.CacheException;
import com.hb0730.commons.cache.impl.remote.AbstractRemoteCache;
import com.hb0730.commons.cache.support.redis.jedis.JedisCacheConfig;
import com.hb0730.commons.cache.support.redis.jedis.JedisProperties;
import com.hb0730.commons.cache.support.serializer.Serializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.params.SetParams;

public class JedisPoolCache<K, V>
extends AbstractRemoteCache<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JedisPoolCache.class);
    private final JedisProperties properties;
    private final Serializer<V> serializer;
    private static volatile JedisPool JEDIS_POOL;

    public JedisPoolCache(JedisCacheConfig<K, V> config) {
        super(config);
        this.properties = config.getProperties();
        this.serializer = config.getSerializer();
        if (Objects.isNull(this.properties)) {
            throw new CacheException("jet properties must be not null");
        }
        this.initRedis();
    }

    private void initRedis() {
        JedisPoolConfig config = new JedisPoolConfig();
        if (null != this.properties.getMaxActive()) {
            config.setMaxTotal(this.properties.getMaxActive().intValue());
        }
        if (null != this.properties.getMaxIdle()) {
            config.setMaxIdle(this.properties.getMaxIdle().intValue());
        }
        if (null != this.properties.getMaxWaitMillis()) {
            config.setMaxWaitMillis((long)this.properties.getMaxWaitMillis().intValue());
        }
        if (null != this.properties.getMinIdle()) {
            config.setMinIdle(this.properties.getMinIdle().intValue());
        }
        config.setTestOnBorrow(true);
        config.setTestWhileIdle(true);
        JEDIS_POOL = new JedisPool((GenericObjectPoolConfig)config, this.properties.getHost(), this.properties.getPort(), this.properties.getTimeout(), this.properties.getPassword(), this.properties.getDatabase());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nonnull
    protected Optional<CacheWrapper<V>> getInternal(@Nonnull K key) {
        Assert.notNull(key, (String)"Cache key must not be null");
        try {
            byte[] newKey = this.buildKey(key);
            try (Jedis jedis = JEDIS_POOL.getResource();){
                byte[] resultBytes = jedis.get(newKey);
                if (resultBytes == null) return Optional.empty();
                CacheWrapper<V> result = this.serializer.deserialize(resultBytes);
                LOGGER.debug("get success key:[{}],result:[{}]", key, result);
                Optional<CacheWrapper<V>> optional = Optional.ofNullable(result);
                return optional;
            }
        }
        catch (Exception e) {
            LOGGER.error("get cache error key [{}], message:[{}]", key, (Object)e.getMessage());
            throw new CacheException("get cache error", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nonnull
    protected Optional<Map<K, CacheWrapper<V>>> getInternal(@Nonnull Set<K> keys) {
        Assert.notNull(keys, (String)"Cache key must not be null");
        try (Jedis jedis = JEDIS_POOL.getResource();){
            ArrayList<K> keyList = new ArrayList<K>(keys);
            byte[][] newKeys = (byte[][])keyList.stream().map(k -> {
                try {
                    return this.buildKey(k);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new CacheException("build key error");
                }
            }).toArray(x$0 -> new byte[x$0][]);
            HashMap<K, CacheWrapper<V>> result = new HashMap<K, CacheWrapper<V>>();
            if (newKeys.length > 0) {
                List mgetResults = jedis.mget(newKeys);
                for (int i = 0; i < mgetResults.size(); ++i) {
                    byte[] value = (byte[])mgetResults.get(i);
                    if (null == value) continue;
                    CacheWrapper<V> resultValue = this.serializer.deserialize(value);
                    K key = keyList.get(i);
                    result.put(key, resultValue);
                }
            }
            Optional<Map<K, CacheWrapper<V>>> optional = Optional.of(result);
            return optional;
        }
        catch (Exception e) {
            LOGGER.error("get cache error key [{}], message:[{}]", keys, (Object)e.getMessage());
            throw new CacheException("get cache error", e);
        }
    }

    @Override
    protected void putInternal(@Nonnull K key, @Nonnull CacheWrapper<V> cacheWrapper) {
        Assert.notNull(key, (String)"Cache key must not be blank");
        Assert.notNull(cacheWrapper, (String)"Cache wrapper must not be null");
        try {
            byte[] keyByte = this.buildKey(key);
            try (Jedis jedis = JEDIS_POOL.getResource();){
                byte[] valueBytes = this.serializer.serialize(cacheWrapper);
                long expireAt = this.expireTimeMs(cacheWrapper.getCreateAt(), cacheWrapper.getExpireAt());
                jedis.psetex(keyByte, expireAt, valueBytes);
            }
        }
        catch (Exception e) {
            LOGGER.error("put cache error message:[{}]", (Object)e.getMessage(), (Object)e);
            throw new CacheException("put cache error", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Boolean putInternalIfAbsent(@Nonnull K key, @Nonnull CacheWrapper<V> cacheWrapper) {
        Assert.notNull(key, (String)"Cache key must not be blank");
        Assert.notNull(cacheWrapper, (String)"Cache wrapper must not be null");
        try {
            byte[] keyByte = this.buildKey(key);
            try (Jedis jedis = JEDIS_POOL.getResource();){
                long expire = this.expireTimeMs(cacheWrapper.getCreateAt(), cacheWrapper.getExpireAt());
                SetParams params = new SetParams();
                params.nx().px(expire);
                byte[] valueBytes = this.serializer.serialize(cacheWrapper);
                jedis.set(keyByte, valueBytes, params);
                Boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            LOGGER.error("put_if_absent cache error message:[{}]", (Object)e.getMessage(), (Object)e);
            throw new CacheException("put ifAbsent error", e);
        }
    }

    @Override
    public void delete(@Nonnull K key) {
        Assert.notNull(key, (String)"Cache key must not be null");
        try {
            byte[] bytes = this.buildKey(key);
            try (Jedis jedis = JEDIS_POOL.getResource();){
                jedis.del(bytes);
                LOGGER.debug("delete cache success key [{}]", key);
            }
        }
        catch (Exception e) {
            LOGGER.error("delete error message:[{}]", (Object)e.getMessage(), (Object)e);
            throw new CacheException("delete cache error", e);
        }
    }

    @Override
    public void delete(@Nonnull Set<K> keys) {
        Assert.notEmpty(keys, (String)"Cache key must not be null");
        try (Jedis jedis = JEDIS_POOL.getResource();){
            byte[][] newKeys = (byte[][])keys.stream().map(k -> {
                try {
                    return this.buildKey(k);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new CacheException("build key error");
                }
            }).toArray(len -> new byte[keys.size()][]);
            jedis.del(newKeys);
            LOGGER.debug("delete cache success key [{}]", keys);
        }
        catch (Exception e) {
            LOGGER.error("delete error message:[{}]", (Object)e.getMessage(), (Object)e);
            throw new CacheException("delete cache error", e);
        }
    }

    public static JedisPool getJEDIS_POOL() {
        return JEDIS_POOL;
    }
}

