/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.cache.support.serializer;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.hb0730.commons.cache.CacheWrapper;
import com.hb0730.commons.cache.exception.SerializationException;
import com.hb0730.commons.cache.support.serializer.Serializer;
import java.io.ByteArrayOutputStream;
import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractSerializer<T>
implements Serializer<T> {
    protected boolean useIdentityNumber;
    private static final int INIT_BUF_SIZE = 256;
    private final int identityNumber;
    private static ThreadLocal<WeakReference<ByteArrayOutputStream>> threadLocal = ThreadLocal.withInitial(() -> new WeakReference<ByteArrayOutputStream>(new ByteArrayOutputStream(256)));

    public AbstractSerializer(boolean useIdentityNumber, int identityNumber) {
        this.useIdentityNumber = useIdentityNumber;
        this.identityNumber = identityNumber;
    }

    @Nullable
    protected abstract byte[] doSerialize(@Nonnull ByteArrayOutputStream var1, @Nullable Object var2) throws Exception;

    @Override
    @Nullable
    public byte[] serialize(@Nullable CacheWrapper<T> obj) throws SerializationException {
        if (obj == null) {
            return EMPTY_ARRAY;
        }
        WeakReference<ByteArrayOutputStream> ref = threadLocal.get();
        ByteArrayOutputStream bos = (ByteArrayOutputStream)ref.get();
        if (bos == null) {
            bos = new ByteArrayOutputStream(256);
            threadLocal.set(new WeakReference<ByteArrayOutputStream>(bos));
        }
        try {
            byte[] headerBuffer;
            if (this.useIdentityNumber) {
                headerBuffer = new byte[4];
                this.writeHeader(headerBuffer, this.identityNumber);
                bos.write(headerBuffer);
            }
            headerBuffer = this.doSerialize(bos, obj);
            return headerBuffer;
        }
        catch (Exception e) {
            throw new SerializationException("Cannot serialize", e);
        }
        finally {
            bos.reset();
        }
    }

    protected abstract CacheWrapper<T> doDeserialize(@Nullable byte[] var1) throws Exception;

    @Override
    @Nullable
    public CacheWrapper<T> deserialize(@Nullable byte[] buffer) throws SerializationException {
        if (buffer == null || 0 == buffer.length) {
            return null;
        }
        try {
            return this.doDeserialize(buffer);
        }
        catch (Exception e) {
            throw new SerializationException("decode error", e);
        }
    }

    protected void writeHeader(byte[] buf, int header) {
        buf[0] = (byte)(header >> 24 & 0xFF);
        buf[1] = (byte)(header >> 16 & 0xFF);
        buf[2] = (byte)(header >> 8 & 0xFF);
        buf[3] = (byte)(header & 0xFF);
    }

    protected JavaType getJavaType(Class<?> clazz) {
        return TypeFactory.defaultInstance().constructType(clazz);
    }

    public boolean isUseIdentityNumber() {
        return this.useIdentityNumber;
    }

    public int getIdentityNumber() {
        return this.identityNumber;
    }
}

