/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.cache.support.serializer.impl;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.hb0730.commons.cache.CacheWrapper;
import com.hb0730.commons.cache.exception.SerializationException;
import com.hb0730.commons.cache.support.serializer.AbstractSerializer;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Jackson2JsonCacheWrapperSerializer<T>
extends AbstractSerializer<T> {
    private final ObjectMapper objectMapper;
    public static final int IDENTITY_NUMBER = 1251293825;
    public JavaType javaType;

    public Jackson2JsonCacheWrapperSerializer(boolean useIdentityNumber, Class<T> type) {
        this(useIdentityNumber, new ObjectMapper(), type);
    }

    public Jackson2JsonCacheWrapperSerializer(boolean useIdentityNumber, JavaType type) {
        this(useIdentityNumber, new ObjectMapper(), type);
    }

    public Jackson2JsonCacheWrapperSerializer(boolean useIdentityNumber, ObjectMapper objectMapper, Class<T> type) {
        super(useIdentityNumber, 1251293825);
        this.objectMapper = objectMapper;
        this.javaType = this.getJavaType(type);
    }

    public Jackson2JsonCacheWrapperSerializer(boolean useIdentityNumber, ObjectMapper objectMapper, JavaType type) {
        super(useIdentityNumber, 1251293825);
        this.objectMapper = objectMapper;
        this.javaType = type;
    }

    @Override
    protected CacheWrapper<T> doDeserialize(@Nullable byte[] buffer) throws Exception {
        if (null == buffer || 0 == buffer.length) {
            return null;
        }
        try {
            JavaType javaType = TypeFactory.defaultInstance().constructParametricType(CacheWrapper.class, new JavaType[]{this.getJavaType()});
            if (this.useIdentityNumber) {
                return (CacheWrapper)this.getObjectMapper().readValue(buffer, 4, buffer.length - 4, javaType);
            }
            return (CacheWrapper)this.getObjectMapper().readValue(buffer, javaType);
        }
        catch (Exception e) {
            throw new SerializationException("jackson deserialize error:" + e.getMessage(), e);
        }
    }

    @Override
    protected byte[] doSerialize(@Nonnull ByteArrayOutputStream outStream, Object value) throws Exception {
        if (null == value) {
            return EMPTY_ARRAY;
        }
        this.getObjectMapper().writeValue((OutputStream)outStream, value);
        outStream.flush();
        return outStream.toByteArray();
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public JavaType getJavaType() {
        return this.javaType;
    }
}

