/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.cache.support.serializer.impl;

import com.hb0730.commons.cache.CacheWrapper;
import com.hb0730.commons.cache.support.serializer.AbstractSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JdkCacheSerializer
extends AbstractSerializer<Object> {
    public static final JdkCacheSerializer INSTANCE = new JdkCacheSerializer(true);
    public static final int IDENTITY_NUMBER = 1251293824;

    public JdkCacheSerializer(boolean useIdentityNumber) {
        super(useIdentityNumber, 1251293824);
    }

    @Override
    protected byte[] doSerialize(@Nonnull ByteArrayOutputStream outStream, Object value) throws Exception {
        if (null == value) {
            return EMPTY_ARRAY;
        }
        ObjectOutputStream oos = new ObjectOutputStream(outStream);
        oos.writeObject(value);
        oos.flush();
        return outStream.toByteArray();
    }

    @Override
    protected CacheWrapper<Object> doDeserialize(@Nullable byte[] buffer) throws Exception {
        if (null == buffer || 0 == buffer.length) {
            return null;
        }
        ByteArrayInputStream in = this.useIdentityNumber ? new ByteArrayInputStream(buffer, 4, buffer.length - 4) : new ByteArrayInputStream(buffer);
        ObjectInputStream ois = this.buildObjectInputStream(in);
        return (CacheWrapper)ois.readObject();
    }

    protected ObjectInputStream buildObjectInputStream(ByteArrayInputStream in) throws IOException {
        return new ObjectInputStream(in);
    }
}

