/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.cache.support.serializer.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.hb0730.commons.cache.CacheWrapper;
import com.hb0730.commons.cache.exception.SerializationException;
import com.hb0730.commons.cache.support.serializer.AbstractSerializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.cache.support.NullValue;
import org.springframework.util.StringUtils;

public class GenericJackson2JsonCacheWrapperSerializer
extends AbstractSerializer<Object> {
    public static final int IDENTITY_NUMBER = 1251293826;
    private final ObjectMapper mapper;

    public GenericJackson2JsonCacheWrapperSerializer(boolean useIdentityNumber) {
        this(useIdentityNumber, new ObjectMapper());
    }

    public GenericJackson2JsonCacheWrapperSerializer(boolean useIdentityNumber, ObjectMapper mapper) {
        this(useIdentityNumber, null, mapper);
    }

    public GenericJackson2JsonCacheWrapperSerializer(boolean useIdentityNumber, String classPropertyTypeName, ObjectMapper mapper) {
        super(useIdentityNumber, 1251293826);
        GenericJackson2JsonCacheWrapperSerializer.registerNullValueSerializer(mapper, classPropertyTypeName);
        this.mapper = mapper;
        if (StringUtils.hasText((String)classPropertyTypeName)) {
            mapper.activateDefaultTypingAsProperty(mapper.getPolymorphicTypeValidator(), ObjectMapper.DefaultTyping.NON_FINAL, classPropertyTypeName);
        } else {
            mapper.activateDefaultTyping(mapper.getPolymorphicTypeValidator(), ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.PROPERTY);
        }
    }

    public static void registerNullValueSerializer(ObjectMapper objectMapper, @org.springframework.lang.Nullable String classPropertyTypeName) {
        objectMapper.registerModule((Module)new SimpleModule().addSerializer((JsonSerializer)new NullValueSerializer(classPropertyTypeName)));
    }

    @Override
    @Nullable
    protected byte[] doSerialize(@Nonnull ByteArrayOutputStream outStream, @Nullable Object value) throws Exception {
        if (null == value) {
            return EMPTY_ARRAY;
        }
        this.getMapper().writeValue((OutputStream)outStream, value);
        outStream.flush();
        return outStream.toByteArray();
    }

    @Override
    protected CacheWrapper<Object> doDeserialize(@Nullable byte[] buffer) throws Exception {
        if (null == buffer || 0 == buffer.length) {
            return null;
        }
        try {
            if (this.useIdentityNumber) {
                return (CacheWrapper)this.getMapper().readValue(buffer, 4, buffer.length - 4, CacheWrapper.class);
            }
            return (CacheWrapper)this.getMapper().readValue(buffer, CacheWrapper.class);
        }
        catch (Exception e) {
            throw new SerializationException("jackson deserialize error:" + e.getMessage(), e);
        }
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    private static class NullValueSerializer
    extends StdSerializer<NullValue> {
        private static final long serialVersionUID = 1999052150548658808L;
        private final String classIdentifier;

        NullValueSerializer(@org.springframework.lang.Nullable String classIdentifier) {
            super(NullValue.class);
            this.classIdentifier = StringUtils.hasText((String)classIdentifier) ? classIdentifier : "@class";
        }

        public void serialize(NullValue value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStartObject();
            jgen.writeStringField(this.classIdentifier, NullValue.class.getName());
            jgen.writeEndObject();
        }
    }
}

