/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.encrypt.digest;

import com.hb0730.commons.encrypt.constant.Algorithm;
import com.hb0730.commons.lang.codec.HexUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5Utils {
    public static String md5(String data) {
        byte[] bytes = MD5Utils.md5(data.getBytes());
        return HexUtils.encodeHexString((byte[])bytes, (boolean)true);
    }

    public static byte[] md5(byte[] data) {
        if (data.length == 0) {
            throw new IllegalArgumentException("data must be not null");
        }
        try {
            MessageDigest digest = MessageDigest.getInstance(Algorithm.MD5.getAlgorithm());
            return digest.digest(data);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("MD5 error", e);
        }
    }

    public static String md5(String data, String salt) {
        byte[] bytes = MD5Utils.md5WithSalt(data.getBytes(), salt.getBytes(), 1);
        return HexUtils.encodeHexString((byte[])bytes, (boolean)true);
    }

    public static byte[] md5(byte[] data, byte[] salt) {
        return MD5Utils.md5WithSalt(data, salt, 1);
    }

    public static String md5(String data, String salt, int hashCount) {
        byte[] bytes = MD5Utils.md5WithSalt(data.getBytes(), salt.getBytes(), hashCount);
        return HexUtils.encodeHexString((byte[])bytes, (boolean)true);
    }

    public static byte[] md5(byte[] data, byte[] salt, int hashCount) {
        return MD5Utils.md5WithSalt(data, salt, hashCount);
    }

    private static byte[] md5WithSalt(byte[] data, byte[] salt, int hashCount) {
        MessageDigest digest;
        if (data.length == 0) {
            throw new IllegalArgumentException("data must be not null");
        }
        try {
            digest = MessageDigest.getInstance(Algorithm.MD5.getAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("md5 error", e);
        }
        if (salt != null) {
            digest.reset();
            digest.update(salt);
        }
        byte[] bytes = digest.digest(data);
        for (int i = 0; i < hashCount; ++i) {
            digest.reset();
            bytes = digest.digest(bytes);
        }
        return bytes;
    }
}

