/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.encrypt.digest;

import com.hb0730.commons.encrypt.constant.Algorithm;
import com.hb0730.commons.lang.codec.HexUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SHAUtils {
    public static String sha(String data) {
        return SHAUtils.sha(data, Algorithm.SHA);
    }

    public static byte[] sha(byte[] data) {
        return SHAUtils.sha(data, Algorithm.SHA);
    }

    public static String sha1(String data) {
        return SHAUtils.sha(data, Algorithm.SHA1);
    }

    public static byte[] sha1(byte[] data) {
        return SHAUtils.sha(data, Algorithm.SHA1);
    }

    public static String sha224(String data) {
        return SHAUtils.sha(data, Algorithm.SHA224);
    }

    public static byte[] sha224(byte[] data) {
        return SHAUtils.sha(data, Algorithm.SHA224);
    }

    public static String sha256(String data) {
        return SHAUtils.sha(data, Algorithm.SHA256);
    }

    public static byte[] sha256(byte[] data) {
        return SHAUtils.sha(data, Algorithm.SHA256);
    }

    public static String sha384(String data) {
        return SHAUtils.sha(data, Algorithm.SHA384);
    }

    public static byte[] sha384(byte[] data) {
        return SHAUtils.sha(data, Algorithm.SHA384);
    }

    public static String sha512(String data) {
        return SHAUtils.sha(data, Algorithm.SHA512);
    }

    public static byte[] sha512(byte[] data) {
        return SHAUtils.sha(data, Algorithm.SHA512);
    }

    public static String sha3_224(String data) {
        return SHAUtils.sha(data, Algorithm.SHA3_224);
    }

    public static byte[] sha3_224(byte[] data) {
        return SHAUtils.sha(data, Algorithm.SHA3_224);
    }

    public static String sha3_256(String data) {
        return SHAUtils.sha(data, Algorithm.SHA3_256);
    }

    public static byte[] sha3_256(byte[] data) {
        return SHAUtils.sha(data, Algorithm.SHA3_256);
    }

    public static String sha3_384(String data) {
        return SHAUtils.sha(data, Algorithm.SHA3_384);
    }

    public static byte[] sha3_384(byte[] data) {
        return SHAUtils.sha(data, Algorithm.SHA3_384);
    }

    public static String sha3_512(String data) {
        return SHAUtils.sha(data, Algorithm.SHA3_512);
    }

    public static byte[] sha3_512(byte[] data) {
        return SHAUtils.sha(data, Algorithm.SHA3_512);
    }

    public static String sha(String data, Algorithm algorithm) {
        byte[] bytes = SHAUtils.sha(data.getBytes(), algorithm);
        return HexUtils.encodeHexString((byte[])bytes, (boolean)true);
    }

    public static byte[] sha(byte[] data, Algorithm algorithm) {
        if (data.length == 0) {
            throw new IllegalArgumentException("data must be not null");
        }
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm.getAlgorithm());
            return digest.digest(data);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("SHA error", e);
        }
    }
}

