/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.encrypt.symmetry;

import com.hb0730.commons.encrypt.constant.Algorithm;
import com.hb0730.commons.encrypt.constant.Mode;
import com.hb0730.commons.encrypt.constant.Padding;
import com.hb0730.commons.encrypt.exceptions.EncryptException;
import com.hb0730.commons.lang.StringUtils;
import com.hb0730.commons.lang.codec.Base64Utils;
import java.nio.charset.StandardCharsets;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class AESUtils {
    public static String encrypt(String data, String key) {
        return AESUtils.encrypt(data, key, null, Mode.ECB, Padding.PKCS5Padding);
    }

    public static byte[] encrypt(byte[] data, byte[] key) {
        return AESUtils.encrypt(data, key, null, Mode.ECB, Padding.PKCS5Padding);
    }

    public static String encrypt(String data, String key, String iv) {
        return AESUtils.encrypt(data, key, iv, Mode.CBC, Padding.PKCS7Padding);
    }

    public static byte[] encrypt(byte[] data, byte[] key, String iv) {
        return AESUtils.encrypt(data, key, iv, Mode.CBC, Padding.PKCS7Padding);
    }

    public static String encrypt(String data, String key, Mode mode, Padding padding) {
        return AESUtils.encrypt(data, key, null, mode, padding);
    }

    public static byte[] encrypt(byte[] data, byte[] key, Mode mode, Padding padding) {
        return AESUtils.encrypt(data, key, null, mode, padding);
    }

    public static String encrypt(String data, String key, String iv, Mode mode, Padding padding) {
        if (StringUtils.isEmpty((CharSequence)data)) {
            return null;
        }
        byte[] encrypt = AESUtils.encrypt(data.getBytes(), key.getBytes(), iv, mode, padding);
        return Base64Utils.encodeToString((byte[])encrypt);
    }

    public static byte[] encrypt(byte[] data, byte[] key, String iv, Mode mode, Padding padding) {
        AESUtils.check(data, key, iv, mode, padding);
        try {
            SecretKeySpec secretKeySpec = AESUtils.getSecretKeySpec(key);
            String algorithm = Algorithm.getAlgorithm(Algorithm.AES, mode, padding);
            Cipher cipher = Cipher.getInstance(algorithm);
            if (StringUtils.isNotBlank((CharSequence)iv)) {
                AlgorithmParameters parameters = AlgorithmParameters.getInstance(Algorithm.AES.getAlgorithm());
                parameters.init(new IvParameterSpec(iv.getBytes(StandardCharsets.UTF_8)));
                cipher.init(1, (Key)secretKeySpec, parameters);
            } else {
                cipher.init(1, secretKeySpec);
            }
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new EncryptException("AES encrypt error", e);
        }
    }

    public static String decrypt(String data, String key) {
        return AESUtils.decrypt(data, key, null, Mode.ECB, Padding.PKCS5Padding);
    }

    public static byte[] decrypt(byte[] data, byte[] key) {
        return AESUtils.decrypt(data, key, null, Mode.ECB, Padding.PKCS5Padding);
    }

    public static String decrypt(String data, String key, String iv) {
        return AESUtils.decrypt(data, key, iv, Mode.CBC, Padding.PKCS7Padding);
    }

    public static byte[] decrypt(byte[] data, byte[] key, String iv) {
        return AESUtils.decrypt(data, key, iv, Mode.CBC, Padding.PKCS7Padding);
    }

    public static String decrypt(String data, String key, Mode mode, Padding padding) {
        return AESUtils.decrypt(data, key, null, mode, padding);
    }

    public static byte[] decrypt(byte[] data, byte[] key, Mode mode, Padding padding) {
        return AESUtils.decrypt(data, key, null, mode, padding);
    }

    public static String decrypt(String data, String key, String iv, Mode mode, Padding padding) {
        if (StringUtils.isEmpty((CharSequence)data)) {
            return null;
        }
        byte[] decrypt = AESUtils.decrypt(Base64Utils.decodeFromString((String)data), key.getBytes(), iv, mode, padding);
        return new String(decrypt);
    }

    public static byte[] decrypt(byte[] data, byte[] key, String iv, Mode mode, Padding padding) {
        AESUtils.check(data, key, iv, mode, padding);
        try {
            SecretKeySpec secretKeySpec = AESUtils.getSecretKeySpec(key);
            String algorithm = Algorithm.getAlgorithm(Algorithm.AES, mode, padding);
            Cipher cipher = Cipher.getInstance(algorithm);
            if (StringUtils.isNotBlank((CharSequence)iv)) {
                AlgorithmParameters parameters = AlgorithmParameters.getInstance(Algorithm.AES.getAlgorithm());
                parameters.init(new IvParameterSpec(iv.getBytes(StandardCharsets.UTF_8)));
                cipher.init(2, (Key)secretKeySpec, parameters);
            } else {
                cipher.init(2, secretKeySpec);
            }
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new EncryptException("AES decrypt error", e);
        }
    }

    public static byte[] generateKey() {
        return AESUtils.generateKey(128);
    }

    public static byte[] generateKey(int length) {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(Algorithm.AES.getAlgorithm());
            keyGenerator.init(length);
            SecretKey secretKey = keyGenerator.generateKey();
            return secretKey.getEncoded();
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptException("AES key generate error", e);
        }
    }

    private static SecretKeySpec getSecretKeySpec(byte[] key) {
        return new SecretKeySpec(key, Algorithm.AES.getAlgorithm());
    }

    private static void check(byte[] data, byte[] key, String iv, Mode mode, Padding padding) {
        AESUtils.checkKey(key);
        AESUtils.checkModeAndPadding(data, mode, padding);
        if (StringUtils.isNotBlank((CharSequence)iv)) {
            AESUtils.checkIv(iv);
            if (mode == Mode.ECB) {
                throw new EncryptException("AES ECB mode does not use an IV");
            }
        }
    }

    private static void checkModeAndPadding(byte[] data, Mode mode, Padding padding) {
        boolean is16NotSupport;
        if (mode == Mode.NONE) {
            throw new EncryptException("invalid AES mode");
        }
        if (padding == Padding.SSL3Padding || padding == Padding.PKCS1Padding) {
            throw new EncryptException("invalid AES padding");
        }
        boolean bl = is16NotSupport = padding == Padding.NoPadding && (mode == Mode.ECB || mode == Mode.CBC) && data.length % 16 != 0;
        if (is16NotSupport) {
            throw new EncryptException("data length must be multiple of 16 bytes on ECB/NoPadding or CBC/NoPadding mode");
        }
    }

    private static void checkKey(byte[] key) {
        if (key == null) {
            throw new EncryptException("AES key cannot be null");
        }
        if (key.length != 16 && key.length != 24 && key.length != 32) {
            throw new EncryptException("AES key not 16/24/32 bytes long");
        }
    }

    private static void checkIv(String iv) {
        if (iv.length() != 16) {
            throw new EncryptException("AES iv not 16 bytes long");
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

