/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.encrypt.symmetry;

public class RC4Utils {
    private static final int BOX_LENGTH = 256;

    public static String encryptOrDecrypt(String content, String key) {
        Integer[] box = new Integer[256];
        Character[] characters = new Character[content.length()];
        StringBuilder stringBuilder = new StringBuilder();
        RC4Utils.ksa(box, key);
        RC4Utils.rpga(box, characters, content.length());
        for (int i = 0; i < content.length(); ++i) {
            stringBuilder.append((char)(content.charAt(i) ^ characters[i].charValue()));
        }
        return stringBuilder.toString();
    }

    private static void ksa(Integer[] sbox, String key) {
        for (int i = 0; i < 256; ++i) {
            sbox[i] = i;
        }
        int j = 0;
        for (int i = 0; i < 256; ++i) {
            j = (j + sbox[i] + key.charAt(i % key.length())) % 256;
            RC4Utils.swap(sbox, i, j);
        }
    }

    private static void rpga(Integer[] sbox, Character[] characters, int length) {
        int i = 0;
        int j = 0;
        for (int k = 0; k < length; ++k) {
            i = (i + 1) % 256;
            j = (j + sbox[i]) % 256;
            RC4Utils.swap(sbox, i, j);
            characters[k] = Character.valueOf((char)sbox[(sbox[i] + sbox[j]) % 256].intValue());
        }
    }

    private static void swap(Integer[] sbox, int i, int j) {
        Integer mTemp = sbox[i];
        sbox[i] = sbox[j];
        sbox[j] = mTemp;
    }
}

