/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.encrypt.asymmetric;

import com.hb0730.commons.encrypt.constant.Algorithm;
import com.hb0730.commons.encrypt.constant.Mode;
import com.hb0730.commons.encrypt.constant.Padding;
import com.hb0730.commons.encrypt.constant.RSASignType;
import com.hb0730.commons.encrypt.exceptions.EncryptException;
import com.hb0730.commons.encrypt.pojo.RSAKeyPair;
import com.hb0730.commons.lang.StringUtils;
import com.hb0730.commons.lang.codec.Base64Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class RSAUtils {
    public static String encryptByPublicKey(String data, String publicKey) {
        return RSAUtils.encryptByPublicKey(data, publicKey, Mode.ECB, Padding.PKCS1Padding);
    }

    public static byte[] encryptByPublicKey(byte[] data, byte[] publicKey) {
        return RSAUtils.encryptByPublicKey(data, publicKey, Mode.ECB, Padding.PKCS1Padding);
    }

    public static String encryptByPublicKey(String data, String publicKey, Mode mode, Padding padding) {
        return RSAUtils.encrypt(data, (RSAKey)RSAUtils.getPublicKey(publicKey), mode, padding);
    }

    public static byte[] encryptByPublicKey(byte[] data, byte[] publicKey, Mode mode, Padding padding) {
        return RSAUtils.encrypt(data, (RSAKey)RSAUtils.getPublicKey(publicKey), mode, padding);
    }

    public static String encryptByPrivateKey(String data, String privateKey) {
        return RSAUtils.encryptByPrivateKey(data, privateKey, Mode.ECB, Padding.PKCS1Padding);
    }

    public static byte[] encryptByPrivateKey(byte[] data, byte[] privateKey) {
        return RSAUtils.encryptByPrivateKey(data, privateKey, Mode.ECB, Padding.PKCS1Padding);
    }

    public static String encryptByPrivateKey(String data, String privateKey, Mode mode, Padding padding) {
        return RSAUtils.encrypt(data, (RSAKey)RSAUtils.getPrivateKey(privateKey), mode, padding);
    }

    public static byte[] encryptByPrivateKey(byte[] data, byte[] privateKey, Mode mode, Padding padding) {
        return RSAUtils.encrypt(data, (RSAKey)RSAUtils.getPrivateKey(privateKey), mode, padding);
    }

    public static String encrypt(String data, RSAKey rsaKey, Mode mode, Padding padding) {
        if (StringUtils.isEmpty((CharSequence)data)) {
            return null;
        }
        return Base64Utils.encodeToString((byte[])RSAUtils.encrypt(data.getBytes(), rsaKey, mode, padding));
    }

    public static byte[] encrypt(byte[] data, RSAKey rsaKey, Mode mode, Padding padding) {
        RSAUtils.check(mode, padding);
        try {
            String algorithm = Algorithm.getAlgorithm(Algorithm.RSA, mode, padding);
            Cipher cipher = Cipher.getInstance(algorithm);
            cipher.init(1, (Key)((Object)rsaKey));
            int keyLength = rsaKey.getModulus().bitLength();
            int blockSize = keyLength / 8 - 11;
            return RSAUtils.segmentHandling(cipher, data, blockSize);
        }
        catch (Exception e) {
            throw new EncryptException("RSA encrypt error", e);
        }
    }

    public static String decryptByPublicKey(String data, String publicKey) {
        return RSAUtils.decryptByPublicKey(data, publicKey, Mode.ECB, Padding.PKCS1Padding);
    }

    public static byte[] decryptByPublicKey(byte[] data, String publicKey) {
        return RSAUtils.decryptByPublicKey(data, publicKey, Mode.ECB, Padding.PKCS1Padding);
    }

    public static String decryptByPublicKey(String data, String publicKey, Mode mode, Padding padding) {
        try {
            RSAPublicKey rsaPublicKey = RSAUtils.getPublicKey(publicKey);
            return RSAUtils.decrypt(data, (RSAKey)rsaPublicKey, mode, padding);
        }
        catch (Exception e) {
            throw new EncryptException("RSA decrypt error", e);
        }
    }

    public static byte[] decryptByPublicKey(byte[] data, String publicKey, Mode mode, Padding padding) {
        RSAPublicKey rsaPublicKey = RSAUtils.getPublicKey(publicKey);
        return RSAUtils.decrypt(data, (RSAKey)rsaPublicKey, mode, padding);
    }

    public static String decryptByPrivateKey(String data, String privateKey) {
        return RSAUtils.decryptByPrivateKey(data, privateKey, Mode.ECB, Padding.PKCS1Padding);
    }

    public static byte[] decryptByPrivateKey(byte[] data, String privateKey) {
        return RSAUtils.decryptByPrivateKey(data, privateKey, Mode.ECB, Padding.PKCS1Padding);
    }

    public static String decryptByPrivateKey(String data, String privateKey, Mode mode, Padding padding) {
        RSAPrivateKey rsaPrivateKey = RSAUtils.getPrivateKey(privateKey);
        return RSAUtils.decrypt(data, (RSAKey)rsaPrivateKey, mode, padding);
    }

    public static byte[] decryptByPrivateKey(byte[] data, String privateKey, Mode mode, Padding padding) {
        RSAPrivateKey rsaPrivateKey = RSAUtils.getPrivateKey(privateKey);
        return RSAUtils.decrypt(data, (RSAKey)rsaPrivateKey, mode, padding);
    }

    public static String decrypt(String data, RSAKey rsaKey, Mode mode, Padding padding) {
        if (StringUtils.isEmpty((CharSequence)data)) {
            return null;
        }
        byte[] decrypt = RSAUtils.decrypt(Base64Utils.decode((byte[])data.getBytes()), rsaKey, mode, padding);
        return new String(decrypt);
    }

    public static byte[] decrypt(byte[] data, RSAKey rsaKey, Mode mode, Padding padding) {
        RSAUtils.check(mode, padding);
        try {
            String algorithm = Algorithm.getAlgorithm(Algorithm.RSA, mode, padding);
            Cipher cipher = Cipher.getInstance(algorithm);
            cipher.init(2, (Key)((Object)rsaKey));
            int keyLength = rsaKey.getModulus().bitLength();
            int blockSize = keyLength / 8;
            return RSAUtils.segmentHandling(cipher, data, blockSize);
        }
        catch (Exception e) {
            throw new EncryptException("RSA decrypt error", e);
        }
    }

    public static String sign(RSASignType signType, String data, String privateKey) {
        return RSAUtils.sign(signType, data.getBytes(), privateKey);
    }

    public static String sign(RSASignType signType, byte[] data, String privateKey) {
        try {
            RSAPrivateKey rsaPrivateKey = RSAUtils.getPrivateKey(privateKey);
            Signature signature = Signature.getInstance(signType.getType());
            signature.initSign(rsaPrivateKey);
            signature.update(data);
            return Base64Utils.encodeToString((byte[])signature.sign());
        }
        catch (Exception e) {
            throw new EncryptException("RSA sign error", e);
        }
    }

    public static boolean verifySign(RSASignType signType, String data, String publicKey, String sign) {
        return RSAUtils.verifySign(signType, data.getBytes(), publicKey, Base64Utils.decodeFromString((String)sign));
    }

    public static boolean verifySign(RSASignType signType, byte[] data, String publicKey, byte[] sign) {
        try {
            RSAPublicKey rsaPublicKey = RSAUtils.getPublicKey(publicKey);
            Signature signature = Signature.getInstance(signType.getType());
            signature.initVerify(rsaPublicKey);
            signature.update(data);
            return signature.verify(sign);
        }
        catch (Exception e) {
            throw new EncryptException("RSA verify sign error", e);
        }
    }

    public static RSAKeyPair generateKey() {
        return RSAUtils.generateKey(2048);
    }

    public static RSAKeyPair generateKey(int keysize) {
        KeyPairGenerator kpg;
        SecureRandom sr = new SecureRandom();
        try {
            kpg = KeyPairGenerator.getInstance(Algorithm.RSA.getAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptException("RSA key generate error", e);
        }
        kpg.initialize(keysize, sr);
        KeyPair keyPair = kpg.generateKeyPair();
        RSAPublicKey rsaPublicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey rsaPrivateKey = (RSAPrivateKey)keyPair.getPrivate();
        RSAKeyPair rsaKeyPair = new RSAKeyPair();
        rsaKeyPair.setPublicKey(Base64Utils.encodeToString((byte[])rsaPublicKey.getEncoded()));
        rsaKeyPair.setPrivateKey(Base64Utils.encodeToString((byte[])rsaPrivateKey.getEncoded()));
        rsaKeyPair.setModules(rsaPublicKey.getModulus());
        return rsaKeyPair;
    }

    private static byte[] segmentHandling(Cipher cipher, byte[] data, int blockSize) throws IOException, IllegalBlockSizeException, BadPaddingException {
        byte[] result;
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            int dataLength = data.length;
            for (int i = 0; i < dataLength; i += blockSize) {
                int contentLength = Math.min(dataLength - i, blockSize);
                byte[] doFinal = cipher.doFinal(data, i, contentLength);
                byteArrayOutputStream.write(doFinal);
            }
            result = byteArrayOutputStream.toByteArray();
        }
        return result;
    }

    public static RSAPublicKey getPublicKey(String publicKey) {
        return RSAUtils.getPublicKey(Base64Utils.decode((byte[])publicKey.getBytes()));
    }

    public static RSAPublicKey getPublicKey(byte[] key) {
        try {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(key);
            KeyFactory keyFactory = KeyFactory.getInstance(Algorithm.RSA.getAlgorithm());
            return (RSAPublicKey)keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            throw new EncryptException(e);
        }
    }

    public static RSAPrivateKey getPrivateKey(String privateKey) {
        return RSAUtils.getPrivateKey(Base64Utils.decode((byte[])privateKey.getBytes()));
    }

    public static RSAPrivateKey getPrivateKey(byte[] key) {
        try {
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(key);
            KeyFactory keyFactory = KeyFactory.getInstance(Algorithm.RSA.getAlgorithm());
            return (RSAPrivateKey)keyFactory.generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw new EncryptException(e);
        }
    }

    private static void check(Mode mode, Padding padding) {
        if (mode != Mode.NONE && mode != Mode.ECB) {
            throw new EncryptException("invalid RSA mode");
        }
        if (padding != Padding.PKCS1Padding && padding != Padding.NoPadding && padding != Padding.OAEPPadding && padding != Padding.ISO9796d1Padding) {
            throw new EncryptException("invalid RSA padding");
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

