/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.encrypt.asymmetric;

import com.hb0730.commons.encrypt.constant.Algorithm;
import com.hb0730.commons.encrypt.constant.SM2SignType;
import com.hb0730.commons.encrypt.exceptions.EncryptException;
import com.hb0730.commons.encrypt.pojo.SM2KeyPair;
import com.hb0730.commons.encrypt.utils.KeyEncodedUtils;
import com.hb0730.commons.lang.StringUtils;
import com.hb0730.commons.lang.codec.Base64Utils;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SM2Utils {
    public static String encrypt(String data, String publicKey) {
        return SM2Utils.encrypt(data, SM2Utils.getPublicKey(publicKey));
    }

    public static byte[] encrypt(byte[] data, byte[] publicKey) {
        return SM2Utils.encrypt(data, SM2Utils.getPublicKey(publicKey));
    }

    public static String encrypt(String data, ECPublicKey ecPublicKey) {
        if (StringUtils.isEmpty((CharSequence)data)) {
            return null;
        }
        return Base64Utils.encodeToString((byte[])SM2Utils.encrypt(data.getBytes(), ecPublicKey));
    }

    public static byte[] encrypt(byte[] data, ECPublicKey ecPublicKey) {
        try {
            Cipher cipher = Cipher.getInstance(Algorithm.SM2.getAlgorithm());
            cipher.init(1, ecPublicKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new EncryptException("EC encrypt error", e);
        }
    }

    public static String decrypt(String data, String privateKey) {
        return SM2Utils.decrypt(data, SM2Utils.getPrivateKey(privateKey));
    }

    public static byte[] decrypt(byte[] data, byte[] privateKey) {
        return SM2Utils.decrypt(data, SM2Utils.getPrivateKey(privateKey));
    }

    public static String decrypt(String data, ECPrivateKey ecPrivateKey) {
        if (StringUtils.isEmpty((CharSequence)data)) {
            return null;
        }
        byte[] decrypt = SM2Utils.decrypt(Base64Utils.decode((byte[])data.getBytes()), ecPrivateKey);
        return new String(decrypt);
    }

    public static byte[] decrypt(byte[] data, ECPrivateKey ecPrivateKey) {
        try {
            Cipher cipher = Cipher.getInstance(Algorithm.SM2.getAlgorithm());
            cipher.init(2, ecPrivateKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new EncryptException("EC decrypt error", e);
        }
    }

    public static String sign(SM2SignType signType, String data, String privateKey) {
        return SM2Utils.sign(signType, data.getBytes(), SM2Utils.getPrivateKey(privateKey));
    }

    public static String sign(SM2SignType signType, String data, ECPrivateKey privateKey) {
        return SM2Utils.sign(signType, data.getBytes(), privateKey);
    }

    public static String sign(SM2SignType signType, byte[] data, ECPrivateKey privateKey) {
        try {
            Signature signature = Signature.getInstance(signType.getType());
            signature.initSign(privateKey);
            signature.update(data);
            return Base64Utils.encodeToString((byte[])signature.sign());
        }
        catch (Exception e) {
            throw new EncryptException("EC sign error", e);
        }
    }

    public static boolean verifySign(SM2SignType signType, String data, String publicKey, String sign) {
        return SM2Utils.verifySign(signType, data.getBytes(), publicKey, Base64Utils.decodeFromString((String)sign));
    }

    public static boolean verifySign(SM2SignType signType, String data, ECPublicKey publicKey, String sign) {
        return SM2Utils.verifySign(signType, data.getBytes(), publicKey, Base64Utils.decodeFromString((String)sign));
    }

    public static boolean verifySign(SM2SignType signType, byte[] data, String publicKey, byte[] sign) {
        return SM2Utils.verifySign(signType, data, SM2Utils.getPublicKey(publicKey), sign);
    }

    public static boolean verifySign(SM2SignType signType, byte[] data, ECPublicKey publicKey, byte[] sign) {
        try {
            Signature signature = Signature.getInstance(signType.getType());
            signature.initVerify(publicKey);
            signature.update(data);
            return signature.verify(sign);
        }
        catch (Exception e) {
            throw new EncryptException("EC verify sign error", e);
        }
    }

    public static SM2KeyPair generateKey() {
        return SM2Utils.generateKey(256);
    }

    public static SM2KeyPair generateKey(int keysize) {
        KeyPairGenerator kpg;
        SecureRandom sr = new SecureRandom();
        try {
            kpg = KeyPairGenerator.getInstance(Algorithm.EC.getAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptException("EC key generate error", e);
        }
        kpg.initialize(keysize, sr);
        KeyPair keyPair = kpg.generateKeyPair();
        ECPublicKey ecPublicKey = (ECPublicKey)keyPair.getPublic();
        ECPrivateKey ecPrivateKey = (ECPrivateKey)keyPair.getPrivate();
        SM2KeyPair sm2KeyPair = new SM2KeyPair();
        sm2KeyPair.setPublicKey(KeyEncodedUtils.encodeX509Base64(ecPublicKey.getEncoded()));
        sm2KeyPair.setPrivateKey(KeyEncodedUtils.encodePkcs8Base64(ecPrivateKey.getEncoded()));
        sm2KeyPair.setEcPublicKey(ecPublicKey);
        sm2KeyPair.setEcPrivateKey(ecPrivateKey);
        return sm2KeyPair;
    }

    public static ECPublicKey getPublicKey(String publicKey) {
        return SM2Utils.getPublicKey(Base64Utils.decode((byte[])publicKey.getBytes()));
    }

    public static ECPublicKey getPublicKey(byte[] key) {
        try {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(key);
            KeyFactory keyFactory = KeyFactory.getInstance(Algorithm.EC.getAlgorithm());
            return (ECPublicKey)keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            throw new EncryptException(e);
        }
    }

    public static ECPrivateKey getPrivateKey(String privateKey) {
        return SM2Utils.getPrivateKey(Base64Utils.decode((byte[])privateKey.getBytes()));
    }

    public static ECPrivateKey getPrivateKey(byte[] key) {
        try {
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(key);
            KeyFactory keyFactory = KeyFactory.getInstance(Algorithm.EC.getAlgorithm());
            return (ECPrivateKey)keyFactory.generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw new EncryptException(e);
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

