/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.encrypt.constant;

import com.hb0730.commons.encrypt.constant.Mode;
import com.hb0730.commons.encrypt.constant.Padding;

public enum Algorithm {
    MD5("MD5"),
    SHA("SHA"),
    SHA1("SHA-1"),
    SHA224("SHA-224"),
    SHA256("SHA-256"),
    SHA384("SHA-384"),
    SHA512("SHA-512"),
    SHA3_224("SHA3-224"),
    SHA3_256("SHA3-256"),
    SHA3_384("SHA3-384"),
    SHA3_512("SHA3-512"),
    SM3("SM3"),
    DES("DES"),
    DE_SEDE("DESede"),
    AES("AES"),
    BLOWFISH("Blowfish"),
    SM4("SM4"),
    RC4("RC4"),
    RSA("RSA"),
    SM2("SM2"),
    EC("EC");

    String algorithm;

    private Algorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public static String getAlgorithm(Algorithm algorithm, Mode mode, Padding padding) {
        return algorithm.getAlgorithm() + "/" + mode.getMode() + "/" + padding.getPadding();
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }
}

