/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.encrypt.digest;

import com.hb0730.commons.encrypt.digest.DigestAlgorithm;
import com.hb0730.commons.encrypt.exceptions.EncryptException;
import com.hb0730.commons.lang.codec.HexUtils;
import com.hb0730.commons.lang.collection.ArrayUtils;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;

public class Digester
implements Serializable {
    private static final long serialVersionUID = -1801446861056947483L;
    private MessageDigest messageDigest;
    protected byte[] salt;
    protected int saltPosition;
    protected int digestCount;

    public Digester(DigestAlgorithm algorithm) {
        this.init(algorithm.getValue(), null);
    }

    public Digester(String algorithm) {
        this.init(algorithm, null);
    }

    public Digester(String algorithm, Provider provider) {
        this.init(algorithm, provider);
    }

    public Digester(DigestAlgorithm algorithm, Provider provider) {
        this.init(algorithm.getValue(), provider);
    }

    public Digester init(String algorithm, Provider provider) {
        try {
            this.messageDigest = null == provider ? MessageDigest.getInstance(algorithm) : MessageDigest.getInstance(algorithm, provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptException(e);
        }
        return this;
    }

    public Digester setSalt(byte[] salt) {
        this.salt = salt;
        return this;
    }

    public Digester setSaltPosition(int saltPosition) {
        this.saltPosition = saltPosition;
        return this;
    }

    public Digester setDigestCount(int digestCount) {
        this.digestCount = digestCount;
        return this;
    }

    public Digester reset() {
        this.messageDigest.reset();
        return this;
    }

    public byte[] digest(byte[] data) {
        byte[] result;
        if (this.saltPosition <= 0) {
            result = this.doDigest(this.salt, data);
        } else if (this.saltPosition > data.length) {
            result = this.doDigest(data, this.salt);
        } else if (ArrayUtils.isNotEmpty((Object)this.salt)) {
            this.messageDigest.update(data, 0, this.saltPosition);
            this.messageDigest.update(this.salt);
            this.messageDigest.update(data, this.saltPosition, data.length - this.saltPosition);
            result = this.messageDigest.digest();
        } else {
            result = this.doDigest(new byte[][]{data});
        }
        return this.resetAndRepeatDigest(result);
    }

    public byte[] digest(String data) {
        return this.digest(data, StandardCharsets.UTF_8);
    }

    public byte[] digest(String data, String charset) {
        return this.digest(data, Charset.forName(charset));
    }

    public byte[] digest(String data, Charset charset) {
        return this.digest(data.getBytes(charset));
    }

    public String digestHex(String data) {
        return this.digestHex(data, StandardCharsets.UTF_8);
    }

    public String digestHex(String data, String charset) {
        return this.digestHex(data, Charset.forName(charset));
    }

    public String digestHex(String data, Charset charset) {
        return this.digestHex(data, charset, true);
    }

    public String digestHex(String data, Charset charset, boolean toLowerCase) {
        return HexUtils.encodeHexString((byte[])this.digest(data, charset), (boolean)toLowerCase);
    }

    public MessageDigest getDigest() {
        return this.messageDigest;
    }

    private byte[] doDigest(byte[] ... datas) {
        for (byte[] data : datas) {
            if (null == data) continue;
            this.messageDigest.update(data);
        }
        return this.messageDigest.digest();
    }

    private byte[] resetAndRepeatDigest(byte[] digestData) {
        int digestCount = Math.max(1, this.digestCount);
        this.reset();
        for (int i = 0; i < digestCount - 1; ++i) {
            digestData = this.doDigest(new byte[][]{digestData});
            this.reset();
        }
        return digestData;
    }
}

