/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.encrypt.digest;

import com.hb0730.commons.encrypt.constant.GlobalBouncyCastleProvider;
import com.hb0730.commons.encrypt.digest.DigestAlgorithm;
import com.hb0730.commons.encrypt.digest.Digester;
import com.hb0730.commons.encrypt.digest.HMac;
import com.hb0730.commons.encrypt.digest.HmacAlgorithm;
import com.hb0730.commons.encrypt.digest.MD5;
import com.hb0730.commons.encrypt.digest.SM3;
import com.hb0730.commons.lang.constants.Charsets;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.Provider;
import javax.crypto.SecretKey;

public class Digesters {
    public static byte[] md5(byte[] data) {
        return new MD5(Digesters.getBouncyCastleProvider()).digest(data);
    }

    public static byte[] md5(String data, String charset) {
        return new MD5(Digesters.getBouncyCastleProvider()).digest(data, charset);
    }

    public static byte[] md5(String data) {
        return Digesters.md5(data, "UTF-8");
    }

    public static String md5Hex(String data) {
        return Digesters.md5Hex(data, "UTF-8");
    }

    public static String md5Hex(String data, String charset) {
        return new MD5(Digesters.getBouncyCastleProvider()).digestHex(data, charset);
    }

    public static String md5Hex(String data, Charset charset) {
        return new MD5(Digesters.getBouncyCastleProvider()).digestHex(data, charset);
    }

    public static String md5Hex16(String data, Charset charset) {
        return new MD5(Digesters.getBouncyCastleProvider()).digestHex16(data, charset);
    }

    public static String md5Hex16(String data) {
        return Digesters.md5Hex16(data, Charsets.UTF_8);
    }

    public static String md5HexTo16(String md5Hex) {
        return md5Hex.substring(8, 24);
    }

    public static byte[] sha1(byte[] data) {
        return new Digester(DigestAlgorithm.SHA1, Digesters.getBouncyCastleProvider()).digest(data);
    }

    public static byte[] sha1(String data, String charset) {
        return new Digester(DigestAlgorithm.SHA1, Digesters.getBouncyCastleProvider()).digest(data, charset);
    }

    public static byte[] sha1(String data) {
        return Digesters.sha1(data, "UTF-8");
    }

    public static String sha1Hex(String data, String charset) {
        return new Digester(DigestAlgorithm.SHA1, Digesters.getBouncyCastleProvider()).digestHex(data, charset);
    }

    public static String sha1Hex(String data) {
        return Digesters.sha1Hex(data, "UTF-8");
    }

    public static byte[] sha256(String data, String charset) {
        return new Digester(DigestAlgorithm.SHA256, Digesters.getBouncyCastleProvider()).digest(data, charset);
    }

    public static byte[] sha256(String data) {
        return Digesters.sha256(data, "UTF-8");
    }

    public static String sha256Hex(String data, String charset) {
        return new Digester(DigestAlgorithm.SHA256, Digesters.getBouncyCastleProvider()).digestHex(data, charset);
    }

    public static String sha256Hex(String data) {
        return Digesters.sha256Hex(data, "UTF-8");
    }

    public static HMac hmac(HmacAlgorithm algorithm, byte[] key) {
        return new HMac(algorithm, key, Digesters.getBouncyCastleProvider());
    }

    public static HMac hmac(HmacAlgorithm algorithm, SecretKey key) {
        return new HMac(algorithm, (Key)key, Digesters.getBouncyCastleProvider());
    }

    public static SM3 sm3() {
        return new SM3(Digesters.getBouncyCastleProvider());
    }

    public static String sm3(String data) {
        return Digesters.sm3().digestHex(data);
    }

    public static Digester digester(DigestAlgorithm algorithm) {
        return new Digester(algorithm, Digesters.getBouncyCastleProvider());
    }

    public static Digester digester(String algorithm) {
        return new Digester(algorithm, Digesters.getBouncyCastleProvider());
    }

    public static void disableBouncyCastle() {
        GlobalBouncyCastleProvider.setUseBouncyCastle(false);
    }

    private static Provider getBouncyCastleProvider() {
        return GlobalBouncyCastleProvider.INSTANCE.getProvider();
    }
}

