/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.encrypt.digest;

import com.hb0730.commons.encrypt.digest.HmacAlgorithm;
import com.hb0730.commons.encrypt.exceptions.EncryptException;
import com.hb0730.commons.encrypt.utils.KeyUtils;
import com.hb0730.commons.lang.codec.HexUtils;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.Provider;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class HMac
implements Serializable {
    private static final long serialVersionUID = 4332051904125084523L;
    private Mac mac;

    public static HMac hmac(HmacAlgorithm algorithm) {
        return new HMac(algorithm);
    }

    public static HMac hmac(HmacAlgorithm algorithm, byte[] key) {
        return new HMac(algorithm, key);
    }

    public static HMac hmac(HmacAlgorithm algorithm, SecretKey key) {
        return new HMac(algorithm, (Key)key);
    }

    public HMac(HmacAlgorithm algorithm) {
        this(algorithm, (Key)null);
    }

    public HMac(HmacAlgorithm algorithm, byte[] key) {
        this(algorithm, key, null);
    }

    public HMac(HmacAlgorithm algorithm, byte[] key, Provider provider) {
        this(algorithm.getValue(), key, provider);
    }

    public HMac(HmacAlgorithm algorithm, Key key) {
        this(algorithm, key, null);
    }

    public HMac(HmacAlgorithm algorithm, Key key, Provider provider) {
        this(algorithm.getValue(), key, provider);
    }

    public HMac(String algorithm, byte[] key) {
        this(algorithm, key, null);
    }

    public HMac(String algorithm, byte[] key, Provider provider) {
        this(algorithm, (Key)(key == null ? null : new SecretKeySpec(key, algorithm)), provider);
    }

    public HMac(String algorithm, Key key) {
        this(algorithm, key, null);
    }

    public HMac(String algorithm, Key key, Provider provider) {
        this.init(algorithm, key, provider);
    }

    public HMac init(String algorithm, Key key, Provider provider) {
        try {
            this.mac = null == provider ? Mac.getInstance(algorithm) : Mac.getInstance(algorithm, provider);
            if (null == key) {
                key = KeyUtils.generateKey(algorithm, provider);
            }
            this.mac.init(key);
        }
        catch (Exception e) {
            throw new EncryptException(e);
        }
        return this;
    }

    public byte[] digest(byte[] data) {
        return this.mac.doFinal(data);
    }

    public byte[] digest(String data) {
        return this.digest(data, StandardCharsets.UTF_8);
    }

    public byte[] digest(String data, String charset) {
        return this.digest(data, Charset.forName(charset));
    }

    public byte[] digest(String data, Charset charset) {
        return this.digest(data.getBytes(charset));
    }

    public String digestHex(String data) {
        return this.digestHex(data, true);
    }

    public String digestHex(String data, boolean toLowerCase) {
        return this.digestHex(data, StandardCharsets.UTF_8, toLowerCase);
    }

    public String digestHex(String data, String charset, boolean toLowerCase) {
        return this.digestHex(data, Charset.forName(charset), toLowerCase);
    }

    public String digestHex(String data, Charset charset, boolean toLowerCase) {
        return HexUtils.encodeHexString((byte[])this.digest(data, charset), (boolean)toLowerCase);
    }

    public Mac getMac() {
        return this.mac;
    }

    public int getMacLength() {
        return this.mac.getMacLength();
    }

    public String getAlgorithm() {
        return this.mac.getAlgorithm();
    }
}

