/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.encrypt.digest;

import com.hb0730.commons.encrypt.constant.HmacType;
import com.hb0730.commons.encrypt.exceptions.EncryptException;
import com.hb0730.commons.lang.codec.HexUtils;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class HmacUtils {
    public static String hmacMD5(String data, String key) {
        return HmacUtils.hmac(data, key, HmacType.HmacMD5);
    }

    public static byte[] hmacMD5(byte[] data, byte[] key) {
        return HmacUtils.hmac(data, key, HmacType.HmacMD5);
    }

    public static String hmacSHA1(String data, String key) {
        return HmacUtils.hmac(data, key, HmacType.HmacSHA1);
    }

    public static byte[] hmacSHA1(byte[] data, byte[] key) {
        return HmacUtils.hmac(data, key, HmacType.HmacSHA1);
    }

    public static String hmacSHA224(String data, String key) {
        return HmacUtils.hmac(data, key, HmacType.HmacSHA224);
    }

    public static byte[] hmacSHA224(byte[] data, byte[] key) {
        return HmacUtils.hmac(data, key, HmacType.HmacSHA224);
    }

    public static String hmacSHA256(String data, String key) {
        return HmacUtils.hmac(data, key, HmacType.HmacSHA256);
    }

    public static byte[] hmacSHA256(byte[] data, byte[] key) {
        return HmacUtils.hmac(data, key, HmacType.HmacSHA256);
    }

    public static String hmacSHA384(String data, String key) {
        return HmacUtils.hmac(data, key, HmacType.HmacSHA384);
    }

    public static byte[] hmacSHA384(byte[] data, byte[] key) {
        return HmacUtils.hmac(data, key, HmacType.HmacSHA384);
    }

    public static String hmacSHA512(String data, String key) {
        return HmacUtils.hmac(data, key, HmacType.HmacSHA512);
    }

    public static byte[] hmacSHA512(byte[] data, byte[] key) {
        return HmacUtils.hmac(data, key, HmacType.HmacSHA512);
    }

    public static String hmac(String data, String key, HmacType hmacType) {
        byte[] bytes = HmacUtils.hmac(data.getBytes(), key.getBytes(), hmacType);
        return HexUtils.encodeHexString((byte[])bytes, (boolean)true);
    }

    public static byte[] hmac(byte[] data, byte[] key, HmacType hmacType) {
        try {
            Mac mac = Mac.getInstance(hmacType.getType());
            SecretKeySpec secretKeySpec = new SecretKeySpec(key, hmacType.getType());
            mac.init(secretKeySpec);
            return mac.doFinal(data);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new EncryptException("hmac error", e);
        }
    }

    public static String generateHmacMD5KeyHex() {
        return HmacUtils.generateKeyHex(HmacType.HmacMD5);
    }

    public static byte[] generateHmacMD5Key() {
        return HmacUtils.generateKey(HmacType.HmacMD5);
    }

    public static String generateHmacSHA1KeyHex() {
        return HmacUtils.generateKeyHex(HmacType.HmacSHA1);
    }

    public static byte[] generateHmacSHA1Key() {
        return HmacUtils.generateKey(HmacType.HmacSHA1);
    }

    public static String generateHmacSHA224KeyHex() {
        return HmacUtils.generateKeyHex(HmacType.HmacSHA224);
    }

    public static byte[] generateHmacSHA224Key() {
        return HmacUtils.generateKey(HmacType.HmacSHA224);
    }

    public static String generateHmacSHA256KeyHex() {
        return HmacUtils.generateKeyHex(HmacType.HmacSHA256);
    }

    public static byte[] generateHmacSHA256Key() {
        return HmacUtils.generateKey(HmacType.HmacSHA256);
    }

    public static String generateHmacSHA384KeyHex() {
        return HmacUtils.generateKeyHex(HmacType.HmacSHA384);
    }

    public static byte[] generateHmacSHA384Key() {
        return HmacUtils.generateKey(HmacType.HmacSHA384);
    }

    public static String generateHmacSHA512KeyHex() {
        return HmacUtils.generateKeyHex(HmacType.HmacSHA512);
    }

    public static byte[] generateHmacSHA512Key() {
        return HmacUtils.generateKey(HmacType.HmacSHA512);
    }

    public static String generateKeyHex(HmacType hmacType) {
        byte[] key = HmacUtils.generateKey(hmacType);
        return HexUtils.encodeHexString((byte[])key, (boolean)true);
    }

    public static byte[] generateKey(HmacType hmacType) {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(hmacType.getType());
            SecretKey secretKey = keyGenerator.generateKey();
            return secretKey.getEncoded();
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptException(e);
        }
    }
}

