/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.encrypt.digest;

import com.hb0730.commons.encrypt.digest.DigestAlgorithm;
import com.hb0730.commons.encrypt.digest.Digester;
import com.hb0730.commons.encrypt.digest.Digesters;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Provider;

public class MD5
extends Digester {
    private static final long serialVersionUID = -770574049010257911L;

    public static MD5 create() {
        return new MD5();
    }

    public MD5() {
        this((Provider)null);
    }

    public MD5(Provider provider) {
        super(DigestAlgorithm.MD5, provider);
    }

    public MD5(byte[] salt) {
        this(salt, null);
    }

    public MD5(byte[] salt, Provider provider) {
        this(salt, 0, 1, provider);
    }

    public MD5(byte[] salt, int digestCount) {
        this(salt, digestCount, null);
    }

    public MD5(byte[] salt, int digestCount, Provider provider) {
        this(salt, 0, digestCount, provider);
    }

    public MD5(byte[] salt, int saltPosition, int digestCount) {
        this(salt, saltPosition, digestCount, null);
    }

    public MD5(byte[] salt, int saltPosition, int digestCount, Provider provider) {
        this(provider);
        this.salt = salt;
        this.saltPosition = saltPosition;
        this.digestCount = digestCount;
    }

    public String digestHex16(String data) {
        return this.digestHex16(data, StandardCharsets.UTF_8);
    }

    public String digestHex16(String data, String charset) {
        return this.digestHex16(data, Charset.forName(charset));
    }

    public String digestHex16(String data, Charset charset) {
        return this.digestHex16(data, charset, true);
    }

    public String digestHex16(String data, Charset charset, boolean toLowerCase) {
        return Digesters.md5HexTo16(this.digestHex(data, charset, toLowerCase));
    }
}

