/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.encrypt.symmetry;

import com.hb0730.commons.encrypt.symmetry.Mode;
import com.hb0730.commons.encrypt.symmetry.Padding;
import com.hb0730.commons.encrypt.symmetry.SymmetricAlgorithm;
import com.hb0730.commons.encrypt.symmetry.SymmetricCrypto;
import com.hb0730.commons.encrypt.utils.KeyUtils;
import com.hb0730.commons.lang.collection.ArrayUtils;
import java.security.Provider;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class AES
extends SymmetricCrypto {
    public AES() {
        this((Provider)null);
    }

    public AES(Provider provider) {
        super(SymmetricAlgorithm.AES, provider);
    }

    public AES(byte[] key) {
        this(key, null);
    }

    public AES(byte[] key, Provider provider) {
        super(SymmetricAlgorithm.AES, key, provider);
    }

    public AES(SecretKey key) {
        this(key, null);
    }

    public AES(SecretKey key, Provider provider) {
        super(SymmetricAlgorithm.AES, key, provider);
    }

    public AES(Mode mode, Padding padding) {
        this(mode.name(), padding.name(), (Provider)null);
    }

    public AES(Mode mode, Padding padding, Provider provider) {
        this(mode.name(), padding.name(), provider);
    }

    public AES(Mode mode, Padding padding, byte[] key) {
        this(mode, padding, key, null, null);
    }

    public AES(Mode mode, Padding padding, byte[] key, Provider provider) {
        this(mode, padding, key, null, provider);
    }

    public AES(Mode mode, Padding padding, byte[] key, byte[] iv) {
        this(mode.name(), padding.name(), key, iv, null);
    }

    public AES(Mode mode, Padding padding, byte[] key, byte[] iv, Provider provider) {
        this(mode.name(), padding.name(), key, iv, provider);
    }

    public AES(Mode mode, Padding padding, SecretKey key) {
        this(mode, padding, key, (IvParameterSpec)null, null);
    }

    public AES(Mode mode, Padding padding, SecretKey key, Provider provider) {
        this(mode, padding, key, (IvParameterSpec)null, provider);
    }

    public AES(Mode mode, Padding padding, SecretKey key, byte[] iv) {
        this(mode, padding, key, ArrayUtils.isEmpty((Object)iv) ? null : new IvParameterSpec(iv), null);
    }

    public AES(Mode mode, Padding padding, SecretKey key, byte[] iv, Provider provider) {
        this(mode, padding, key, ArrayUtils.isEmpty((Object)iv) ? null : new IvParameterSpec(iv), provider);
    }

    public AES(Mode mode, Padding padding, SecretKey key, IvParameterSpec iv) {
        this(mode.name(), padding.name(), key, iv, null);
    }

    public AES(Mode mode, Padding padding, SecretKey key, IvParameterSpec iv, Provider provider) {
        this(mode.name(), padding.name(), key, iv, provider);
    }

    public AES(String mode, String padding) {
        this(mode, padding, (Provider)null);
    }

    public AES(String mode, String padding, Provider provider) {
        this(mode, padding, (byte[])null, provider);
    }

    public AES(String mode, String padding, byte[] key) {
        this(mode, padding, key, (Provider)null);
    }

    public AES(String mode, String padding, byte[] key, Provider provider) {
        this(mode, padding, key, null, provider);
    }

    public AES(String mode, String padding, byte[] key, byte[] iv) {
        this(mode, padding, key, iv, null);
    }

    public AES(String mode, String padding, byte[] key, byte[] iv, Provider provider) {
        this(mode, padding, KeyUtils.generateKey(SymmetricAlgorithm.AES.getValue(), key, provider), ArrayUtils.isEmpty((Object)iv) ? null : new IvParameterSpec(iv), provider);
    }

    public AES(String mode, String padding, SecretKey key) {
        this(mode, padding, key, (Provider)null);
    }

    public AES(String mode, String padding, SecretKey key, Provider provider) {
        this(mode, padding, key, null, provider);
    }

    public AES(String mode, String padding, SecretKey secretKey, IvParameterSpec iv) {
        this(mode, padding, secretKey, iv, null);
    }

    public AES(String mode, String padding, SecretKey secretKey, IvParameterSpec iv, Provider provider) {
        super(String.format("AES/%s/%s", mode, padding), secretKey, iv, provider);
    }
}

