/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.encrypt.symmetry;

import com.hb0730.commons.encrypt.constant.Algorithm;
import com.hb0730.commons.encrypt.constant.Mode;
import com.hb0730.commons.encrypt.constant.Padding;
import com.hb0730.commons.encrypt.exceptions.EncryptException;
import com.hb0730.commons.lang.StringUtils;
import com.hb0730.commons.lang.codec.Base64Utils;
import java.nio.charset.StandardCharsets;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class DESedeUtils {
    public static String encrypt(String data, String key) {
        return DESedeUtils.encrypt(data, key, null, Mode.ECB, Padding.PKCS5Padding);
    }

    public static byte[] encrypt(byte[] data, byte[] key) {
        return DESedeUtils.encrypt(data, key, null, Mode.ECB, Padding.PKCS5Padding);
    }

    public static String encrypt(String data, String key, String iv) {
        return DESedeUtils.encrypt(data, key, iv, Mode.CBC, Padding.PKCS7Padding);
    }

    public static byte[] encrypt(byte[] data, byte[] key, String iv) {
        return DESedeUtils.encrypt(data, key, iv, Mode.CBC, Padding.PKCS7Padding);
    }

    public static String encrypt(String data, String key, Mode mode, Padding padding) {
        return DESedeUtils.encrypt(data, key, null, mode, padding);
    }

    public static byte[] encrypt(byte[] data, byte[] key, Mode mode, Padding padding) {
        return DESedeUtils.encrypt(data, key, null, mode, padding);
    }

    public static String encrypt(String data, String key, String iv, Mode mode, Padding padding) {
        if (StringUtils.isEmpty((CharSequence)data)) {
            return null;
        }
        byte[] encrypt = DESedeUtils.encrypt(data.getBytes(), key.getBytes(), iv, mode, padding);
        return Base64Utils.encodeToString((byte[])encrypt);
    }

    public static byte[] encrypt(byte[] data, byte[] key, String iv, Mode mode, Padding padding) {
        DESedeUtils.check(data, key, iv, mode, padding);
        try {
            SecretKeySpec secretKeySpec = DESedeUtils.getSecretKeySpec(key);
            String algorithm = Algorithm.getAlgorithm(Algorithm.DE_SEDE, mode, padding);
            Cipher cipher = Cipher.getInstance(algorithm);
            if (StringUtils.isNotBlank((CharSequence)iv)) {
                AlgorithmParameters parameters = AlgorithmParameters.getInstance(Algorithm.DE_SEDE.getAlgorithm());
                parameters.init(new IvParameterSpec(iv.getBytes(StandardCharsets.UTF_8)));
                cipher.init(1, (Key)secretKeySpec, parameters);
            } else {
                cipher.init(1, secretKeySpec);
            }
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new EncryptException("DESede encrypt error", e);
        }
    }

    public static String decrypt(String data, String key) {
        return DESedeUtils.decrypt(data, key, null, Mode.ECB, Padding.PKCS5Padding);
    }

    public static byte[] decrypt(byte[] data, byte[] key) {
        return DESedeUtils.decrypt(data, key, null, Mode.ECB, Padding.PKCS5Padding);
    }

    public static String decrypt(String data, String key, String iv) {
        return DESedeUtils.decrypt(data, key, iv, Mode.CBC, Padding.PKCS7Padding);
    }

    public static byte[] decrypt(byte[] data, byte[] key, String iv) {
        return DESedeUtils.decrypt(data, key, iv, Mode.CBC, Padding.PKCS7Padding);
    }

    public static String decrypt(String data, String key, Mode mode, Padding padding) {
        return DESedeUtils.decrypt(data, key, null, mode, padding);
    }

    public static byte[] decrypt(byte[] data, byte[] key, Mode mode, Padding padding) {
        return DESedeUtils.decrypt(data, key, null, mode, padding);
    }

    public static String decrypt(String data, String key, String iv, Mode mode, Padding padding) {
        if (StringUtils.isEmpty((CharSequence)data)) {
            return null;
        }
        byte[] decrypt = DESedeUtils.decrypt(Base64Utils.decodeFromString((String)data), key.getBytes(), iv, mode, padding);
        return new String(decrypt);
    }

    public static byte[] decrypt(byte[] data, byte[] key, String iv, Mode mode, Padding padding) {
        DESedeUtils.check(data, key, iv, mode, padding);
        try {
            SecretKeySpec secretKeySpec = DESedeUtils.getSecretKeySpec(key);
            String algorithm = Algorithm.getAlgorithm(Algorithm.DE_SEDE, mode, padding);
            Cipher cipher = Cipher.getInstance(algorithm);
            if (StringUtils.isNotBlank((CharSequence)iv)) {
                AlgorithmParameters parameters = AlgorithmParameters.getInstance(Algorithm.DE_SEDE.getAlgorithm());
                parameters.init(new IvParameterSpec(iv.getBytes(StandardCharsets.UTF_8)));
                cipher.init(2, (Key)secretKeySpec, parameters);
            } else {
                cipher.init(2, secretKeySpec);
            }
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new EncryptException("DESede decrypt error", e);
        }
    }

    public static byte[] generateKey() {
        return DESedeUtils.generateKey(112);
    }

    public static byte[] generateKey(int length) {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(Algorithm.DE_SEDE.getAlgorithm());
            keyGenerator.init(length);
            SecretKey secretKey = keyGenerator.generateKey();
            return secretKey.getEncoded();
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptException("DESede key generate error", e);
        }
    }

    private static SecretKeySpec getSecretKeySpec(byte[] key) {
        return new SecretKeySpec(key, Algorithm.DE_SEDE.getAlgorithm());
    }

    private static void check(byte[] data, byte[] key, String iv, Mode mode, Padding padding) {
        DESedeUtils.checkKey(key);
        DESedeUtils.checkModeAndPadding(data, mode, padding);
        if (StringUtils.isNotBlank((CharSequence)iv)) {
            DESedeUtils.checkIv(iv);
            if (mode == Mode.ECB) {
                throw new EncryptException("DESede ECB mode does not use an IV");
            }
        }
    }

    private static void checkModeAndPadding(byte[] data, Mode mode, Padding padding) {
        boolean is8NotSupport;
        if (mode == Mode.NONE) {
            throw new EncryptException("invalid DESede mode");
        }
        if (padding == Padding.SSL3Padding || padding == Padding.PKCS1Padding) {
            throw new EncryptException("invalid DESede padding");
        }
        boolean bl = is8NotSupport = padding == Padding.NoPadding && (mode == Mode.ECB || mode == Mode.CBC) && data.length % 8 != 0;
        if (is8NotSupport) {
            throw new EncryptException("data length must be multiple of 8 bytes on ECB/NoPadding or CBC/NoPadding mode");
        }
    }

    private static void checkKey(byte[] key) {
        if (key == null) {
            throw new EncryptException("DESede key cannot be null");
        }
        if (key.length != 16 && key.length != 24) {
            throw new EncryptException("DESede key not 16/24 bytes long");
        }
    }

    private static void checkIv(String iv) {
        if (iv.length() != 8) {
            throw new EncryptException("DESede iv not 8 bytes long");
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

