/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.encrypt.symmetry;

import com.hb0730.commons.encrypt.symmetry.Mode;
import com.hb0730.commons.encrypt.symmetry.Padding;
import com.hb0730.commons.encrypt.symmetry.SymmetricAlgorithm;
import com.hb0730.commons.encrypt.symmetry.SymmetricCrypto;
import com.hb0730.commons.encrypt.utils.KeyUtils;
import com.hb0730.commons.lang.collection.ArrayUtils;
import java.security.Provider;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class SM4
extends SymmetricCrypto {
    public SM4() {
        this((Provider)null);
    }

    public SM4(Provider provider) {
        super(SymmetricAlgorithm.SM4.getValue(), provider);
    }

    public SM4(byte[] key) {
        this(key, null);
    }

    public SM4(byte[] key, Provider provider) {
        super(SymmetricAlgorithm.SM4.getValue(), key, provider);
    }

    public SM4(Mode mode, Padding padding) {
        this(mode, padding, (Provider)null);
    }

    public SM4(Mode mode, Padding padding, Provider provider) {
        this(mode.name(), padding.name(), provider);
    }

    public SM4(Mode mode, Padding padding, byte[] key) {
        this(mode, padding, key, (Provider)null);
    }

    public SM4(Mode mode, Padding padding, byte[] key, Provider provider) {
        this(mode, padding, key, null, provider);
    }

    public SM4(Mode mode, Padding padding, byte[] key, byte[] iv) {
        this(mode, padding, key, iv, null);
    }

    public SM4(Mode mode, Padding padding, byte[] key, byte[] iv, Provider provider) {
        this(mode.name(), padding.name(), key, iv, provider);
    }

    public SM4(Mode mode, Padding padding, SecretKey key) {
        this(mode, padding, key, (Provider)null);
    }

    public SM4(Mode mode, Padding padding, SecretKey key, Provider provider) {
        this(mode, padding, key, (IvParameterSpec)null, provider);
    }

    public SM4(Mode mode, Padding padding, SecretKey key, byte[] iv) {
        this(mode, padding, key, iv, null);
    }

    public SM4(Mode mode, Padding padding, SecretKey key, byte[] iv, Provider provider) {
        this(mode, padding, key, ArrayUtils.isEmpty((Object)iv) ? null : new IvParameterSpec(iv), provider);
    }

    public SM4(Mode mode, Padding padding, SecretKey key, IvParameterSpec iv) {
        this(mode, padding, key, iv, null);
    }

    public SM4(Mode mode, Padding padding, SecretKey key, IvParameterSpec iv, Provider provider) {
        this(mode.name(), padding.name(), key, iv, provider);
    }

    public SM4(String mode, String padding) {
        this(mode, padding, (Provider)null);
    }

    public SM4(String mode, String padding, Provider provider) {
        this(mode, padding, (byte[])null, provider);
    }

    public SM4(String mode, String padding, byte[] key) {
        this(mode, padding, key, (Provider)null);
    }

    public SM4(String mode, String padding, byte[] key, Provider provider) {
        this(mode, padding, key, null, provider);
    }

    public SM4(String mode, String padding, byte[] key, byte[] iv) {
        this(mode, padding, key, iv, null);
    }

    public SM4(String mode, String padding, byte[] key, byte[] iv, Provider provider) {
        this(mode, padding, KeyUtils.generateKey(SymmetricAlgorithm.SM4.getValue(), key, provider), ArrayUtils.isEmpty((Object)iv) ? null : new IvParameterSpec(iv), provider);
    }

    public SM4(String mode, String padding, SecretKey key) {
        this(mode, padding, key, (Provider)null);
    }

    public SM4(String mode, String padding, SecretKey key, Provider provider) {
        this(mode, padding, key, null, provider);
    }

    public SM4(String mode, String padding, SecretKey key, IvParameterSpec iv) {
        this(mode, padding, key, iv, null);
    }

    public SM4(String mode, String padding, SecretKey key, IvParameterSpec iv, Provider provider) {
        super(String.format("%s/%s/%s", SymmetricAlgorithm.SM4.getValue(), mode, padding), key, iv, provider);
    }
}

