/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.encrypt.symmetry;

import com.hb0730.commons.encrypt.constant.Algorithm;
import com.hb0730.commons.encrypt.constant.Mode;
import com.hb0730.commons.encrypt.constant.Padding;
import com.hb0730.commons.encrypt.exceptions.EncryptException;
import com.hb0730.commons.lang.StringUtils;
import com.hb0730.commons.lang.codec.Base64Utils;
import java.nio.charset.StandardCharsets;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SM4Utils {
    public static String encrypt(String data, String key) {
        return SM4Utils.encrypt(data, key, null, Mode.ECB, Padding.PKCS5Padding);
    }

    public static byte[] encrypt(byte[] data, byte[] key) {
        return SM4Utils.encrypt(data, key, null, Mode.ECB, Padding.PKCS5Padding);
    }

    public static String encrypt(String data, String key, String iv) {
        return SM4Utils.encrypt(data, key, iv, Mode.CBC, Padding.PKCS7Padding);
    }

    public static byte[] encrypt(byte[] data, byte[] key, String iv) {
        return SM4Utils.encrypt(data, key, iv, Mode.CBC, Padding.PKCS7Padding);
    }

    public static String encrypt(String data, String key, Mode mode, Padding padding) {
        return SM4Utils.encrypt(data, key, null, mode, padding);
    }

    public static byte[] encrypt(byte[] data, byte[] key, Mode mode, Padding padding) {
        return SM4Utils.encrypt(data, key, null, mode, padding);
    }

    public static String encrypt(String data, String key, String iv, Mode mode, Padding padding) {
        if (StringUtils.isEmpty((CharSequence)data)) {
            return null;
        }
        byte[] encrypt = SM4Utils.encrypt(data.getBytes(), key.getBytes(), iv, mode, padding);
        return Base64Utils.encodeToString((byte[])encrypt);
    }

    public static byte[] encrypt(byte[] data, byte[] key, String iv, Mode mode, Padding padding) {
        SM4Utils.check(data, key, iv, mode, padding);
        try {
            SecretKeySpec secretKeySpec = SM4Utils.getSecretKeySpec(key);
            String algorithm = Algorithm.getAlgorithm(Algorithm.SM4, mode, padding);
            Cipher cipher = Cipher.getInstance(algorithm);
            if (StringUtils.isNotBlank((CharSequence)iv)) {
                AlgorithmParameters parameters = AlgorithmParameters.getInstance(Algorithm.SM4.getAlgorithm());
                parameters.init(new IvParameterSpec(iv.getBytes(StandardCharsets.UTF_8)));
                cipher.init(1, (Key)secretKeySpec, parameters);
            } else {
                cipher.init(1, secretKeySpec);
            }
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new EncryptException("SM4 encrypt error", e);
        }
    }

    public static String decrypt(String data, String key) {
        return SM4Utils.decrypt(data, key, null, Mode.ECB, Padding.PKCS5Padding);
    }

    public static byte[] decrypt(byte[] data, byte[] key) {
        return SM4Utils.decrypt(data, key, null, Mode.ECB, Padding.PKCS5Padding);
    }

    public static String decrypt(String data, String key, String iv) {
        return SM4Utils.decrypt(data, key, iv, Mode.CBC, Padding.PKCS7Padding);
    }

    public static byte[] decrypt(byte[] data, byte[] key, String iv) {
        return SM4Utils.decrypt(data, key, iv, Mode.CBC, Padding.PKCS7Padding);
    }

    public static String decrypt(String data, String key, Mode mode, Padding padding) {
        return SM4Utils.decrypt(data, key, null, mode, padding);
    }

    public static byte[] decrypt(byte[] data, byte[] key, Mode mode, Padding padding) {
        return SM4Utils.decrypt(data, key, null, mode, padding);
    }

    public static String decrypt(String data, String key, String iv, Mode mode, Padding padding) {
        if (StringUtils.isEmpty((CharSequence)data)) {
            return null;
        }
        byte[] decrypt = SM4Utils.decrypt(Base64Utils.decodeFromString((String)data), key.getBytes(), iv, mode, padding);
        return new String(decrypt);
    }

    public static byte[] decrypt(byte[] data, byte[] key, String iv, Mode mode, Padding padding) {
        SM4Utils.check(data, key, iv, mode, padding);
        try {
            SecretKeySpec secretKeySpec = SM4Utils.getSecretKeySpec(key);
            String algorithm = Algorithm.getAlgorithm(Algorithm.SM4, mode, padding);
            Cipher cipher = Cipher.getInstance(algorithm);
            if (StringUtils.isNotBlank((CharSequence)iv)) {
                AlgorithmParameters parameters = AlgorithmParameters.getInstance(Algorithm.SM4.getAlgorithm());
                parameters.init(new IvParameterSpec(iv.getBytes(StandardCharsets.UTF_8)));
                cipher.init(2, (Key)secretKeySpec, parameters);
            } else {
                cipher.init(2, secretKeySpec);
            }
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new EncryptException("SM4 decrypt error", e);
        }
    }

    public static byte[] generateKey() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(Algorithm.SM4.getAlgorithm());
            keyGenerator.init(128);
            SecretKey secretKey = keyGenerator.generateKey();
            return secretKey.getEncoded();
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptException("SM4 key generate error", e);
        }
    }

    private static SecretKeySpec getSecretKeySpec(byte[] key) {
        return new SecretKeySpec(key, Algorithm.SM4.getAlgorithm());
    }

    private static void check(byte[] data, byte[] key, String iv, Mode mode, Padding padding) {
        SM4Utils.checkKey(key);
        SM4Utils.checkModeAndPadding(data, mode, padding);
        if (StringUtils.isNotBlank((CharSequence)iv)) {
            SM4Utils.checkIv(iv);
            if (mode == Mode.ECB) {
                throw new EncryptException("SM4 ECB mode does not use an IV");
            }
        }
    }

    private static void checkModeAndPadding(byte[] data, Mode mode, Padding padding) {
        boolean is16NotSupport;
        if (mode == Mode.NONE) {
            throw new EncryptException("invalid SM4 mode");
        }
        if (padding == Padding.SSL3Padding || padding == Padding.PKCS1Padding) {
            throw new EncryptException("invalid SM4 padding");
        }
        boolean bl = is16NotSupport = padding == Padding.NoPadding && (mode == Mode.ECB || mode == Mode.CBC) && data.length % 16 != 0;
        if (is16NotSupport) {
            throw new EncryptException("data length must be multiple of 16 bytes on ECB/NoPadding or CBC/NoPadding mode");
        }
    }

    private static void checkKey(byte[] key) {
        if (key == null) {
            throw new EncryptException("SM4 key cannot be null");
        }
        if (key.length != 16) {
            throw new EncryptException("SM4 key not 16 bytes long");
        }
    }

    private static void checkIv(String iv) {
        if (iv.length() != 16) {
            throw new EncryptException("SM4 iv not 16 bytes long");
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

