/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.encrypt.symmetry;

import com.hb0730.commons.encrypt.exceptions.EncryptException;
import com.hb0730.commons.encrypt.symmetry.Padding;
import com.hb0730.commons.encrypt.symmetry.SymmetricAlgorithm;
import com.hb0730.commons.encrypt.utils.KeyUtils;
import com.hb0730.commons.encrypt.utils.SecureUtils;
import com.hb0730.commons.lang.Validate;
import com.hb0730.commons.lang.codec.Base64Utils;
import com.hb0730.commons.lang.codec.HexUtils;
import com.hb0730.commons.lang.collection.ArrayUtils;
import com.hb0730.commons.lang.constants.Charsets;
import com.hb0730.commons.lang.nums.RandomUtils;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;

public class SymmetricCrypto
implements Serializable {
    private static final long serialVersionUID = -8853771073013990289L;
    private static final String PBE = "PBE";
    private SecretKey secretKey;
    private Cipher cipher;
    private AlgorithmParameterSpec params;
    private boolean isZeroPadding;

    public SymmetricCrypto(SymmetricAlgorithm algorithm) {
        this(algorithm, (Provider)null);
    }

    public SymmetricCrypto(SymmetricAlgorithm algorithm, Provider provider) {
        this(algorithm, (byte[])null, provider);
    }

    public SymmetricCrypto(String algorithm) {
        this(algorithm, (Provider)null);
    }

    public SymmetricCrypto(String algorithm, Provider provider) {
        this(algorithm, (byte[])null, provider);
    }

    public SymmetricCrypto(SymmetricAlgorithm algorithm, byte[] key) {
        this(algorithm, key, null);
    }

    public SymmetricCrypto(SymmetricAlgorithm algorithm, byte[] key, Provider provider) {
        this(algorithm.getValue(), key, provider);
    }

    public SymmetricCrypto(SymmetricAlgorithm algorithm, SecretKey key) {
        this(algorithm, key, null);
    }

    public SymmetricCrypto(SymmetricAlgorithm algorithm, SecretKey key, Provider provider) {
        this(algorithm.getValue(), key, provider);
    }

    public SymmetricCrypto(String algorithm, byte[] key) {
        this(algorithm, key, null);
    }

    public SymmetricCrypto(String algorithm, byte[] key, Provider provider) {
        this(algorithm, KeyUtils.generateKey(algorithm, key, provider), provider);
    }

    public SymmetricCrypto(String algorithm, SecretKey secretKey) {
        this(algorithm, secretKey, (AlgorithmParameterSpec)null);
    }

    public SymmetricCrypto(String algorithm, SecretKey secretKey, Provider provider) {
        this(algorithm, secretKey, null, provider);
    }

    public SymmetricCrypto(String algorithm, SecretKey secretKey, AlgorithmParameterSpec paramsSpec) {
        this(algorithm, secretKey, paramsSpec, null);
    }

    public SymmetricCrypto(String algorithm, SecretKey secretKey, AlgorithmParameterSpec paramsSpec, Provider provider) {
        this.init(algorithm, secretKey, provider);
        if (null != paramsSpec) {
            this.setParams(paramsSpec);
        }
    }

    public SymmetricCrypto init(String algorithm, SecretKey secretKey, Provider provider) {
        Validate.notBlank((CharSequence)algorithm, (String)"'algorithm' must be not blank !", (Object[])new Object[0]);
        this.secretKey = secretKey;
        if (algorithm.startsWith(PBE)) {
            this.params = new PBEParameterSpec(RandomUtils.randomBytes((int)8), 100);
        }
        if (algorithm.contains(Padding.ZeroPadding.name())) {
            algorithm = algorithm.replace(Padding.ZeroPadding.name(), Padding.NoPadding.name());
            this.isZeroPadding = true;
        }
        this.cipher = SecureUtils.createCipher(algorithm, provider);
        return this;
    }

    public byte[] encrypt(byte[] data) {
        try {
            if (null == this.params) {
                this.cipher.init(1, this.secretKey);
            } else {
                this.cipher.init(1, (Key)this.secretKey, this.params);
            }
            return this.cipher.doFinal(this.paddingDataWithZero(data, this.cipher.getBlockSize()));
        }
        catch (Exception e) {
            throw new EncryptException(e);
        }
    }

    public String encryptHex(byte[] data) {
        return HexUtils.encodeHexString((byte[])this.encrypt(data));
    }

    public String encryptBase64(byte[] data) {
        return Base64Utils.encodeToString((byte[])this.encrypt(data));
    }

    public byte[] encrypt(String data, String charset) {
        return this.encrypt(data, Charset.forName(charset));
    }

    public byte[] encrypt(String data, Charset charset) {
        return this.encrypt(data.getBytes(charset));
    }

    public String encryptHex(String data, String charset) {
        return this.encryptHex(data, Charset.forName(charset));
    }

    public String encryptHex(String data, Charset charset) {
        return HexUtils.encodeHexString((byte[])this.encrypt(data, charset));
    }

    public String encryptBase64(String data, String charset) {
        return this.encryptBase64(data, Charset.forName(charset));
    }

    public String encryptBase64(String data, Charset charset) {
        return Base64Utils.encodeToString((byte[])this.encrypt(data, charset));
    }

    public byte[] encrypt(String data) {
        return this.encrypt(data.getBytes(Charsets.UTF_8));
    }

    public String encryptHex(String data) {
        return HexUtils.encodeHexString((byte[])this.encrypt(data));
    }

    public String encryptBase64(String data) {
        return Base64Utils.encodeToString((byte[])this.encrypt(data));
    }

    public byte[] decrypt(byte[] bytes) {
        byte[] decryptData;
        int blockSize;
        try {
            if (null == this.params) {
                this.cipher.init(2, this.secretKey);
            } else {
                this.cipher.init(2, (Key)this.secretKey, this.params);
            }
            blockSize = this.cipher.getBlockSize();
            decryptData = this.cipher.doFinal(bytes);
        }
        catch (Exception e) {
            throw new EncryptException(e);
        }
        return this.removePadding(decryptData, blockSize);
    }

    public String decryptStr(byte[] bytes, Charset charset) {
        return new String(this.decrypt(bytes), charset);
    }

    public String decryptStr(byte[] bytes) {
        return this.decryptStr(bytes, Charsets.UTF_8);
    }

    public byte[] decrypt(String data) {
        return this.decrypt(SecureUtils.decode(data));
    }

    public String decryptStr(String data, Charset charset) {
        return new String(this.decrypt(data), charset);
    }

    public String decryptStr(String data) {
        return this.decryptStr(data, Charsets.UTF_8);
    }

    public SymmetricCrypto setParams(AlgorithmParameterSpec params) {
        this.params = params;
        return this;
    }

    public SymmetricCrypto setIv(IvParameterSpec iv) {
        this.setParams(iv);
        return this;
    }

    public SymmetricCrypto setIv(byte[] iv) {
        this.setIv(new IvParameterSpec(iv));
        return this;
    }

    public SecretKey getSecretKey() {
        return this.secretKey;
    }

    public Cipher getCipher() {
        return this.cipher;
    }

    private byte[] paddingDataWithZero(byte[] data, int blockSize) {
        int length;
        int remainLength;
        if (this.isZeroPadding && (remainLength = (length = data.length) % blockSize) > 0) {
            return (byte[])ArrayUtils.resize((Object)data, (int)(length + blockSize - remainLength));
        }
        return data;
    }

    private byte[] removePadding(byte[] data, int blockSize) {
        int length;
        int remainLength;
        if (this.isZeroPadding && (remainLength = (length = data.length) % blockSize) == 0) {
            int i;
            for (i = length - 1; i >= 0 && 0 == data[i]; --i) {
            }
            return (byte[])ArrayUtils.resize((Object)data, (int)(i + 1));
        }
        return data;
    }
}

