/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.encrypt.utils;

import com.hb0730.commons.encrypt.exceptions.EncryptException;
import com.hb0730.commons.encrypt.symmetry.SymmetricAlgorithm;
import com.hb0730.commons.lang.StringUtils;
import com.hb0730.commons.lang.nums.RandomUtils;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class KeyUtils {
    private static final String PBE = "PBE";
    private static final String DES = "DES";
    private static final String DES_EDE = "DESede";

    public static SecretKey generateKey(String algorithm, Provider provider) {
        return KeyUtils.generateKey(algorithm, -1, provider);
    }

    public static SecretKey generateKey(String algorithm, int keySize, Provider provider) {
        return KeyUtils.generateKey(algorithm, keySize, null, provider);
    }

    public static SecretKey generateKey(String algorithm, int keySize, SecureRandom random, Provider provider) {
        algorithm = KeyUtils.getMainAlgorithm(algorithm);
        KeyGenerator keyGenerator = KeyUtils.getKeyGenerator(algorithm, provider);
        if (keySize <= 0 && SymmetricAlgorithm.AES.getValue().equals(algorithm)) {
            keySize = 128;
        }
        if (keySize > 0) {
            if (null == random) {
                keyGenerator.init(keySize);
            } else {
                keyGenerator.init(keySize, random);
            }
        }
        return keyGenerator.generateKey();
    }

    public static SecretKey generateKey(String algorithm, KeySpec keySpec, Provider provider) {
        SecretKeyFactory keyFactory = KeyUtils.getSecretKeyFactory(algorithm, provider);
        try {
            return keyFactory.generateSecret(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new EncryptException(e);
        }
    }

    public static SecretKey generateKey(String algorithm, byte[] key, Provider provider) {
        if (StringUtils.isBlank((CharSequence)algorithm)) {
            throw new EncryptException("Algorithm is blank!");
        }
        SecretKey secretKey = algorithm.startsWith(PBE) ? KeyUtils.generatePBEKey(algorithm, null == key ? null : new String(key, StandardCharsets.UTF_8).toCharArray(), provider) : (algorithm.startsWith(DES) ? KeyUtils.generateDESKey(algorithm, key, provider) : (null == key ? KeyUtils.generateKey(algorithm, provider) : new SecretKeySpec(key, algorithm)));
        return secretKey;
    }

    public static SecretKey generateDESKey(String algorithm, byte[] key, Provider provider) {
        SecretKey secretKey;
        if (StringUtils.isBlank((CharSequence)algorithm) || !algorithm.startsWith(DES)) {
            throw new EncryptException("Algorithm [{}] is not a DES algorithm!");
        }
        if (null == key) {
            secretKey = KeyUtils.generateKey(algorithm, provider);
        } else {
            KeySpec keySpec;
            try {
                keySpec = algorithm.startsWith(DES_EDE) ? new DESedeKeySpec(key) : new DESKeySpec(key);
            }
            catch (InvalidKeyException e) {
                throw new EncryptException(e);
            }
            secretKey = KeyUtils.generateKey(algorithm, keySpec, provider);
        }
        return secretKey;
    }

    public static SecretKey generatePBEKey(String algorithm, char[] key, Provider provider) {
        if (StringUtils.isBlank((CharSequence)algorithm) || !algorithm.startsWith(PBE)) {
            throw new EncryptException("Algorithm [{}] is not a PBE algorithm!");
        }
        if (null == key) {
            key = RandomUtils.randomString((int)32, (boolean)true).toCharArray();
        }
        PBEKeySpec spec = new PBEKeySpec(key);
        return KeyUtils.generateKey(algorithm, spec, provider);
    }

    public static SecretKeyFactory getSecretKeyFactory(String algorithm, Provider provider) {
        SecretKeyFactory keyFactory;
        try {
            keyFactory = null == provider ? SecretKeyFactory.getInstance(KeyUtils.getMainAlgorithm(algorithm)) : SecretKeyFactory.getInstance(KeyUtils.getMainAlgorithm(algorithm), provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptException(e);
        }
        return keyFactory;
    }

    private static KeyGenerator getKeyGenerator(String algorithm, Provider provider) {
        KeyGenerator generator;
        try {
            generator = null == provider ? KeyGenerator.getInstance(KeyUtils.getMainAlgorithm(algorithm)) : KeyGenerator.getInstance(KeyUtils.getMainAlgorithm(algorithm), provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptException(e);
        }
        return generator;
    }

    public static String getMainAlgorithm(String algorithm) {
        int slashIndex = algorithm.indexOf(47);
        if (slashIndex > 0) {
            return algorithm.substring(0, slashIndex);
        }
        return algorithm;
    }
}

