/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.http.support.httpclient;

import com.hb0730.commons.http.HttpHeader;
import com.hb0730.commons.http.config.HttpConfig;
import com.hb0730.commons.http.constants.Constants;
import com.hb0730.commons.http.exception.HttpException;
import com.hb0730.commons.http.inter.AbstractAsyncHttp;
import com.hb0730.commons.http.support.callback.HttpCallback;
import com.hb0730.commons.lang.StringUtils;
import com.hb0730.commons.lang.collection.CollectionUtils;
import com.hb0730.commons.lang.map.MapUtils;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.Message;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.http.nio.AsyncEntityConsumer;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.entity.AsyncEntityProducers;
import org.apache.hc.core5.http.nio.entity.StringAsyncEntityConsumer;
import org.apache.hc.core5.http.nio.entity.StringAsyncEntityProducer;
import org.apache.hc.core5.http.nio.support.BasicRequestProducer;
import org.apache.hc.core5.http.nio.support.BasicResponseConsumer;

public class HttpClientAsyncImpl
extends AbstractAsyncHttp {
    private final CloseableHttpAsyncClient httpClient;

    public HttpClientAsyncImpl() {
        this(HttpAsyncClients.createDefault(), new HttpConfig());
    }

    public HttpClientAsyncImpl(HttpConfig config) {
        this(HttpAsyncClients.createDefault(), config);
    }

    public HttpClientAsyncImpl(CloseableHttpAsyncClient httpClient, HttpConfig config) {
        super(config);
        this.httpClient = httpClient;
    }

    @Override
    public void get(String url, HttpCallback httpCallback) {
        this.get(url, null, httpCallback);
    }

    @Override
    public void get(String url, Map<String, String> params, HttpCallback httpCallback) {
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new HttpException("request url must be not null");
        }
        String baseUrl = StringUtils.appendIfNotContain((String)url, (String)"?", (String)"&");
        url = baseUrl + MapUtils.parseMapToUrlString(params, (boolean)this.httpConfig.isEncode());
        HttpGet httpGet = new HttpGet(url);
        this.addHeader((BasicHttpRequest)httpGet, this.header);
        StringAsyncEntityProducer entityProducer = new StringAsyncEntityProducer((CharSequence)"");
        BasicRequestProducer producer = new BasicRequestProducer((HttpRequest)httpGet, (AsyncEntityProducer)entityProducer);
        this.exec((HttpUriRequestBase)httpGet, producer, httpCallback);
    }

    @Override
    public void post(String url, HttpCallback httpCallback) {
        this.post(url, "", httpCallback);
    }

    @Override
    public void post(String url, String dataJson, HttpCallback httpCallback) {
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new HttpException("request url must be not null");
        }
        HttpPost httpPost = new HttpPost(url);
        this.addHeader((BasicHttpRequest)httpPost, this.header);
        AsyncEntityProducer entityProducer = StringUtils.isEmpty((CharSequence)dataJson) ? AsyncEntityProducers.create((String)"") : AsyncEntityProducers.create((String)dataJson, (ContentType)ContentType.APPLICATION_JSON);
        BasicRequestProducer producer = new BasicRequestProducer((HttpRequest)httpPost, entityProducer);
        this.exec((HttpUriRequestBase)httpPost, producer, httpCallback);
    }

    @Override
    public void post(String url, Map<String, String> formdata, HttpCallback httpCallback) {
        AsyncEntityProducer entityProducer;
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new HttpException("request url must be not null");
        }
        HttpPost httpPost = new HttpPost(url);
        this.addHeader((BasicHttpRequest)httpPost, this.header);
        if (!CollectionUtils.isEmpty(formdata)) {
            ArrayList requestData = new ArrayList();
            MapUtils.forEach(formdata, (k, v) -> requestData.add(new BasicNameValuePair(k, v)));
            entityProducer = AsyncEntityProducers.createUrlEncoded(requestData, (Charset)Constants.DEFAULT_ENCODING);
        } else {
            entityProducer = AsyncEntityProducers.create((String)"");
        }
        BasicRequestProducer producer = new BasicRequestProducer((HttpRequest)httpPost, entityProducer);
        this.exec((HttpUriRequestBase)httpPost, producer, httpCallback);
    }

    private void addHeader(BasicHttpRequest request, HttpHeader header) {
        if (null == request || null == header) {
            return;
        }
        Map<String, String> headers = header.getHeaders();
        if (CollectionUtils.isEmpty(headers)) {
            return;
        }
        MapUtils.forEach(headers, (arg_0, arg_1) -> ((BasicHttpRequest)request).addHeader(arg_0, arg_1));
    }

    private void addHeader(BasicHttpRequest request) {
        if (null == request) {
            return;
        }
        String ua = "User-Agent";
        Header[] headers = request.getHeaders(ua);
        if (null == headers || headers.length == 0) {
            request.setHeader(ua, (Object)"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/75.0.3770.142 Safari/537.36 simple-http");
        }
    }

    private void exec(HttpUriRequestBase request, BasicRequestProducer producer, final HttpCallback httpCallback) {
        this.addHeader((BasicHttpRequest)request);
        RequestConfig.Builder builder = RequestConfig.custom().setConnectionRequestTimeout(this.httpConfig.getTimeout(), TimeUnit.MILLISECONDS).setConnectTimeout(this.httpConfig.getTimeout(), TimeUnit.MILLISECONDS);
        if (null != this.httpConfig.getProxy()) {
            Proxy proxy = this.httpConfig.getProxy();
            InetSocketAddress address = (InetSocketAddress)proxy.address();
            HttpHost httpHost = new HttpHost(proxy.type().name().toLowerCase(), address.getHostName(), address.getPort());
            builder.setProxy(httpHost);
        }
        request.setConfig(builder.build());
        CharCodingConfig charCodingConfig = CharCodingConfig.custom().setCharset(Constants.DEFAULT_ENCODING).build();
        StringAsyncEntityConsumer entityConsumer = new StringAsyncEntityConsumer(charCodingConfig);
        BasicResponseConsumer consumer = new BasicResponseConsumer((AsyncEntityConsumer)entityConsumer);
        this.httpClient.start();
        this.httpClient.execute((AsyncRequestProducer)producer, (AsyncResponseConsumer)consumer, (FutureCallback)new FutureCallback<Message<HttpResponse, String>>(){

            public void completed(Message<HttpResponse, String> result) {
                if (null == httpCallback) {
                    return;
                }
                HttpResponse head = (HttpResponse)result.getHead();
                if (head.getCode() >= 200 && head.getCode() < 300) {
                    httpCallback.success((String)result.getBody());
                } else {
                    httpCallback.failure((Exception)new ClientProtocolException("Unexpected response status: " + head.getCode()));
                }
            }

            public void failed(Exception ex) {
                if (null == httpCallback) {
                    return;
                }
                httpCallback.failure(ex);
            }

            public void cancelled() {
            }
        });
    }

    public CloseableHttpAsyncClient getHttpClient() {
        return this.httpClient;
    }
}

