/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.http.support.okhttp3;

import com.hb0730.commons.http.config.HttpConfig;
import com.hb0730.commons.http.exception.HttpException;
import com.hb0730.commons.http.inter.AbstractAsyncHttp;
import com.hb0730.commons.http.support.callback.HttpCallback;
import com.hb0730.commons.lang.StringUtils;
import com.hb0730.commons.lang.map.MapUtils;
import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class OkHttp3AsyncImpl
extends AbstractAsyncHttp {
    private final OkHttpClient.Builder clientBuilder;
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");

    public OkHttp3AsyncImpl() {
        this(new HttpConfig());
    }

    public OkHttp3AsyncImpl(HttpConfig config) {
        this(new OkHttpClient().newBuilder(), config);
    }

    public OkHttp3AsyncImpl(OkHttpClient.Builder clientBuilder, HttpConfig config) {
        super(config);
        this.clientBuilder = clientBuilder;
    }

    @Override
    public void get(String url, HttpCallback httpCallback) {
        this.get(url, null, httpCallback);
    }

    @Override
    public void get(String url, Map<String, String> params, HttpCallback httpCallback) {
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new HttpException("request url must be not null");
        }
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse((String)url)).newBuilder();
        if (this.httpConfig.isEncode()) {
            MapUtils.forEach(params, (arg_0, arg_1) -> ((HttpUrl.Builder)urlBuilder).addEncodedQueryParameter(arg_0, arg_1));
        } else {
            MapUtils.forEach(params, (arg_0, arg_1) -> ((HttpUrl.Builder)urlBuilder).addQueryParameter(arg_0, arg_1));
        }
        HttpUrl httpUrl = urlBuilder.build();
        Request.Builder requestBuilder = new Request.Builder().url(httpUrl);
        if (null != this.header) {
            MapUtils.forEach(this.header.getHeaders(), (arg_0, arg_1) -> ((Request.Builder)requestBuilder).addHeader(arg_0, arg_1));
        }
        Request.Builder builder = requestBuilder.get();
        this.exec(builder, httpCallback);
    }

    @Override
    public void post(String url, HttpCallback httpCallback) {
        this.post(url, "", httpCallback);
    }

    @Override
    public void post(String url, String dataJson, HttpCallback httpCallback) {
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new HttpException("request url must be not null");
        }
        Request.Builder requestBuilder = new Request.Builder().url(url);
        if (null != this.header) {
            MapUtils.forEach(this.header.getHeaders(), (arg_0, arg_1) -> ((Request.Builder)requestBuilder).addHeader(arg_0, arg_1));
        }
        RequestBody body = RequestBody.create((String)dataJson, (MediaType)JSON);
        requestBuilder.post(body);
        this.exec(requestBuilder, httpCallback);
    }

    @Override
    public void post(String url, Map<String, String> formdata, HttpCallback httpCallback) {
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new HttpException("request url must be not null");
        }
        FormBody.Builder builder = new FormBody.Builder();
        if (this.httpConfig.isEncode()) {
            MapUtils.forEach(formdata, (arg_0, arg_1) -> ((FormBody.Builder)builder).addEncoded(arg_0, arg_1));
        } else {
            MapUtils.forEach(formdata, (arg_0, arg_1) -> ((FormBody.Builder)builder).add(arg_0, arg_1));
        }
        FormBody body = builder.build();
        Request.Builder requestBuilder = new Request.Builder().url(url).post((RequestBody)body);
        if (null != this.header) {
            MapUtils.forEach(this.header.getHeaders(), (arg_0, arg_1) -> ((Request.Builder)requestBuilder).addHeader(arg_0, arg_1));
        }
        this.exec(requestBuilder, httpCallback);
    }

    private void addHeader(Request.Builder builder) {
        builder.header("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/75.0.3770.142 Safari/537.36 simple-http");
    }

    private void exec(Request.Builder requestBuilder, final HttpCallback httpCallback) {
        this.addHeader(requestBuilder);
        Request request = requestBuilder.build();
        OkHttpClient.Builder builder = this.clientBuilder.connectTimeout(Duration.ofMillis(this.httpConfig.getTimeout())).readTimeout(Duration.ofMillis(this.httpConfig.getTimeout())).writeTimeout(Duration.ofMillis(this.httpConfig.getTimeout()));
        OkHttpClient client = null != this.httpConfig.getProxy() ? builder.proxy(this.httpConfig.getProxy()).build() : builder.build();
        client.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                if (null == httpCallback) {
                    return;
                }
                httpCallback.failure(e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (null == httpCallback) {
                    return;
                }
                try (ResponseBody responseBody = response.body();){
                    if (response.isSuccessful()) {
                        httpCallback.success(responseBody.string());
                    }
                }
            }
        });
    }
}

