/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.http.support.httpclient;

import com.hb0730.commons.http.HttpHeader;
import com.hb0730.commons.http.config.HttpConfig;
import com.hb0730.commons.http.constants.Constants;
import com.hb0730.commons.http.exception.HttpException;
import com.hb0730.commons.http.inter.AbstractSyncHttp;
import com.hb0730.commons.lang.StringUtils;
import com.hb0730.commons.lang.collection.CollectionUtils;
import com.hb0730.commons.lang.map.MapUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpClientSyncImpl
extends AbstractSyncHttp {
    private final CloseableHttpClient httpClient;

    public HttpClientSyncImpl() {
        this(HttpConfig.builder().build(), HttpClients.createDefault());
    }

    public HttpClientSyncImpl(CloseableHttpClient httpClient) {
        super(HttpConfig.builder().build());
        this.httpClient = httpClient;
    }

    public HttpClientSyncImpl(HttpConfig httpConfig, CloseableHttpClient httpClient) {
        super(httpConfig);
        this.httpClient = httpClient;
    }

    @Override
    public String get(String url) {
        return this.get(url, null);
    }

    @Override
    public String get(String url, Map<String, String> params) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            return "";
        }
        String baseUrl = StringUtils.appendIfNotContain((String)url, (String)"?", (String)"&");
        url = baseUrl + MapUtils.parseMapToUrlString(params, (boolean)this.httpConfig.isEncode());
        HttpGet httpGet = new HttpGet(url);
        this.addHeader((HttpRequestBase)httpGet, this.getHeader());
        return this.exec((HttpRequestBase)httpGet);
    }

    @Override
    public String post(String url) {
        return this.post(url, "");
    }

    @Override
    public String post(String url, String dataJson) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            return "";
        }
        HttpPost httpPost = new HttpPost(url);
        if (!StringUtils.isEmpty((CharSequence)dataJson)) {
            StringEntity entity = new StringEntity(dataJson, Constants.DEFAULT_ENCODING);
            entity.setContentEncoding(Constants.DEFAULT_ENCODING.displayName());
            entity.setContentType("application/json; charset=utf-8");
            httpPost.setEntity((HttpEntity)entity);
        }
        this.addHeader((HttpRequestBase)httpPost, this.getHeader());
        return this.exec((HttpRequestBase)httpPost);
    }

    @Override
    public String post(String url, Map<String, String> formdata) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            return "";
        }
        HttpPost httpPost = new HttpPost(url);
        if (!CollectionUtils.isEmpty(formdata)) {
            ArrayList form = new ArrayList();
            MapUtils.forEach(formdata, (k, v) -> form.add(new BasicNameValuePair(k, v)));
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(form, Constants.DEFAULT_ENCODING));
        }
        this.addHeader((HttpRequestBase)httpPost, this.getHeader());
        return this.exec((HttpRequestBase)httpPost);
    }

    private boolean isSuccess(CloseableHttpResponse response) {
        if (response == null) {
            return false;
        }
        if (response.getStatusLine() == null) {
            return false;
        }
        return response.getStatusLine().getStatusCode() >= 200 && response.getStatusLine().getStatusCode() < 300;
    }

    private void addHeader(HttpRequestBase request, HttpHeader header) {
        if (null == request || null == header) {
            return;
        }
        Map<String, String> headers = header.getHeaders();
        if (CollectionUtils.isEmpty(headers)) {
            return;
        }
        MapUtils.forEach(headers, (arg_0, arg_1) -> ((HttpRequestBase)request).addHeader(arg_0, arg_1));
    }

    private void addHeader(HttpRequestBase request) {
        if (null == request) {
            return;
        }
        String ua = "User-Agent";
        Header[] headers = request.getHeaders(ua);
        if (null == headers || headers.length == 0) {
            request.setHeader(ua, "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/75.0.3770.142 Safari/537.36 simple-http");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String exec(HttpRequestBase request) {
        this.addHeader(request);
        int timeout = this.httpConfig.getTimeout() > Integer.MAX_VALUE ? Integer.MAX_VALUE : Long.valueOf(this.httpConfig.getTimeout()).intValue();
        RequestConfig.Builder builder = RequestConfig.custom().setConnectionRequestTimeout(timeout).setConnectTimeout(timeout).setSocketTimeout(timeout);
        if (null != this.httpConfig.getProxy()) {
            Proxy proxy = this.httpConfig.getProxy();
            InetSocketAddress address = (InetSocketAddress)proxy.address();
            HttpHost host = new HttpHost(address.getHostName(), address.getPort(), proxy.type().name().toLowerCase());
            builder.setProxy(host);
        }
        String result = "";
        request.setConfig(builder.build());
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)request);){
            if (!this.isSuccess(response)) {
                String string = null;
                return string;
            }
            HttpEntity entity = response.getEntity();
            if (null == entity) return result;
            result = EntityUtils.toString((HttpEntity)entity, (Charset)Constants.DEFAULT_ENCODING);
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new HttpException("request result error:" + e.getMessage());
        }
    }
}

