/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.http.support.okhttp3;

import com.hb0730.commons.http.config.HttpConfig;
import com.hb0730.commons.http.exception.HttpException;
import com.hb0730.commons.http.inter.AbstractSyncHttp;
import com.hb0730.commons.lang.StringUtils;
import com.hb0730.commons.lang.map.MapUtils;
import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OkHttp3SyncImpl
extends AbstractSyncHttp {
    private final OkHttpClient.Builder clientBuilder;
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");

    public OkHttp3SyncImpl() {
        this(new HttpConfig());
    }

    public OkHttp3SyncImpl(HttpConfig config) {
        this(new OkHttpClient().newBuilder(), config);
    }

    public OkHttp3SyncImpl(OkHttpClient.Builder clientBuilder, HttpConfig config) {
        super(config);
        this.clientBuilder = clientBuilder;
    }

    @Override
    public String get(String url) {
        return this.get(url, null);
    }

    @Override
    public String get(String url, Map<String, String> params) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            return "";
        }
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse((String)url)).newBuilder();
        if (this.httpConfig.isEncode()) {
            MapUtils.forEach(params, (arg_0, arg_1) -> ((HttpUrl.Builder)urlBuilder).addEncodedQueryParameter(arg_0, arg_1));
        } else {
            MapUtils.forEach(params, (arg_0, arg_1) -> ((HttpUrl.Builder)urlBuilder).addQueryParameter(arg_0, arg_1));
        }
        HttpUrl httpUrl = urlBuilder.build();
        Request.Builder requestBuilder = new Request.Builder().url(httpUrl);
        if (null != this.header) {
            MapUtils.forEach(this.header.getHeaders(), (arg_0, arg_1) -> ((Request.Builder)requestBuilder).addHeader(arg_0, arg_1));
        }
        Request.Builder builder = requestBuilder.get();
        return this.exec(builder);
    }

    @Override
    public String post(String url) {
        return this.post(url, "");
    }

    @Override
    public String post(String url, String data) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            return "";
        }
        Request.Builder requestBuilder = new Request.Builder().url(url);
        if (null != this.header) {
            MapUtils.forEach(this.header.getHeaders(), (arg_0, arg_1) -> ((Request.Builder)requestBuilder).addHeader(arg_0, arg_1));
        }
        RequestBody body = RequestBody.create((String)data, (MediaType)JSON);
        requestBuilder.post(body);
        return this.exec(requestBuilder);
    }

    @Override
    public String post(String url, Map<String, String> formdata) {
        FormBody.Builder builder = new FormBody.Builder();
        if (this.httpConfig.isEncode()) {
            MapUtils.forEach(formdata, (arg_0, arg_1) -> ((FormBody.Builder)builder).addEncoded(arg_0, arg_1));
        } else {
            MapUtils.forEach(formdata, (arg_0, arg_1) -> ((FormBody.Builder)builder).add(arg_0, arg_1));
        }
        FormBody body = builder.build();
        Request.Builder requestBuilder = new Request.Builder().url(url).post((RequestBody)body);
        if (null != this.header) {
            MapUtils.forEach(this.header.getHeaders(), (arg_0, arg_1) -> ((Request.Builder)requestBuilder).addHeader(arg_0, arg_1));
        }
        return this.exec(requestBuilder);
    }

    public String exec(Request.Builder requestBuilder) {
        String result = "";
        if (null == requestBuilder) {
            return result;
        }
        this.addHeader(requestBuilder);
        Request request = requestBuilder.build();
        OkHttpClient.Builder builder = this.clientBuilder.connectTimeout(Duration.ofMillis(this.httpConfig.getTimeout())).readTimeout(Duration.ofMillis(this.httpConfig.getTimeout())).writeTimeout(Duration.ofMillis(this.httpConfig.getTimeout()));
        OkHttpClient client = null != this.httpConfig.getProxy() ? builder.proxy(this.httpConfig.getProxy()).build() : builder.build();
        try (Response response = client.newCall(request).execute();){
            if (response.isSuccessful()) {
                result = Objects.requireNonNull(response.body()).string();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new HttpException("http execute error:" + e.getMessage(), e);
        }
        return result;
    }

    private void addHeader(Request.Builder builder) {
        builder.header("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/75.0.3770.142 Safari/537.36 simple-http");
    }
}

