/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.json.gson;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.hb0730.commons.json.AbstractJson;
import com.hb0730.commons.json.exceptions.JsonException;
import com.hb0730.commons.lang.Validate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GsonImpl
extends AbstractJson {
    private static final Gson GSON = new Gson();

    @Override
    public void setMapper(Object mapper) throws JsonException {
        if (!(mapper instanceof Gson)) {
            throw new JsonException("Illegal type");
        }
        this.mapper = mapper;
    }

    @Override
    public Object getMapper() {
        if (null == this.mapper) {
            return GSON;
        }
        return this.mapper;
    }

    @Override
    public <T> T jsonToObject(String json, Class<T> type) throws JsonException {
        return this.jsonToObject(json, type, this.getMapper());
    }

    @Override
    public <T> T jsonToObject(String json, Class<T> type, Object gson) throws JsonException {
        Validate.notBlank((CharSequence)json, (String)"json content must be not null", (Object[])new Object[0]);
        Validate.notNull(type, (String)"target type must be not null", (Object[])new Object[0]);
        Validate.notNull((Object)gson, (String)"gson must be not null", (Object[])new Object[0]);
        if (gson instanceof Gson) {
            try {
                return (T)((Gson)gson).fromJson(json, type);
            }
            catch (JsonParseException e) {
                throw new JsonException(e);
            }
        }
        return null;
    }

    @Override
    public <T> List<T> jsonToList(String json, Class<T> type) throws JsonException {
        return this.jsonToList(json, type, this.getMapper());
    }

    @Override
    public <T> List<T> jsonToList(String json, Class<T> type, Object gson) throws JsonException {
        Validate.notBlank((CharSequence)json, (String)"json content must be not null", (Object[])new Object[0]);
        Validate.notNull(type, (String)"target type must be not null", (Object[])new Object[0]);
        Validate.notNull((Object)gson, (String)"gson must be not null", (Object[])new Object[0]);
        if (gson instanceof Gson) {
            try {
                JsonArray arrayJson = JsonParser.parseString((String)json).getAsJsonArray();
                ArrayList<Object> results = new ArrayList<Object>();
                for (JsonElement element : arrayJson) {
                    results.add(((Gson)gson).fromJson(element, type));
                }
                return results;
            }
            catch (JsonParseException e) {
                throw new JsonException(e);
            }
        }
        return null;
    }

    public <T> List<T> jsonToList2(String json, Class<T> type) throws JsonParseException {
        return this.jsonToList2(json, type, (Gson)this.getMapper());
    }

    public <T> List<T> jsonToList2(String json, Class<T> type, Gson gson) throws JsonParseException {
        Validate.notBlank((CharSequence)json, (String)"json content must be not null", (Object[])new Object[0]);
        Validate.notNull(type, (String)"target type must be not null", (Object[])new Object[0]);
        Validate.notNull((Object)gson, (String)"gson must be not null", (Object[])new Object[0]);
        return (List)gson.fromJson(json, new TypeToken<List<T>>(){}.getType());
    }

    @Override
    public String objectToJson(Object source) throws JsonException {
        return this.objectToJson(source, this.getMapper());
    }

    @Override
    public String objectToJson(Object source, Object gson) throws JsonException {
        Validate.notNull((Object)source, (String)"source object must be not null", (Object[])new Object[0]);
        Validate.notNull((Object)gson, (String)"gson must be not null", (Object[])new Object[0]);
        if (gson instanceof Gson) {
            try {
                return ((Gson)gson).toJson(source);
            }
            catch (JsonParseException e) {
                throw new JsonException(e);
            }
        }
        return null;
    }

    @Override
    public <T> T mapToObject(Map<String, ?> sourceMap, Class<T> type) throws JsonException {
        return this.mapToObject(sourceMap, type, this.getMapper());
    }

    @Override
    public <T> T mapToObject(Map<String, ?> sourceMap, Class<T> type, Object gson) throws JsonException {
        Validate.notNull(sourceMap, (String)"source map must be not null", (Object[])new Object[0]);
        String json = this.objectToJson(sourceMap, gson);
        return this.jsonToObject(json, type, gson);
    }

    @Override
    public <T> Map<String, T> objectToMap(Object source) throws JsonException {
        return this.objectToMap(source, this.getMapper());
    }

    @Override
    public <T> Map<String, T> objectToMap(Object source, Object gson) throws JsonException {
        String json = this.objectToJson(source, gson);
        if (gson instanceof Gson) {
            try {
                return (Map)((Gson)gson).fromJson(json, new TypeToken<Map<String, T>>(){}.getType());
            }
            catch (JsonParseException e) {
                throw new JsonException(e);
            }
        }
        return null;
    }
}

