/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.json.gson;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.hb0730.commons.lang.Validate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GsonUtils {
    private static final Gson DEFAULT_GSON = new Gson();

    private GsonUtils() {
    }

    public static <T> T jsonToObject(String json, Class<T> type) throws JsonParseException {
        return GsonUtils.jsonToObject(json, type, DEFAULT_GSON);
    }

    public static <T> T jsonToObject(String json, Class<T> type, Gson gson) {
        Validate.notBlank((CharSequence)json, (String)"json content must be not null", (Object[])new Object[0]);
        Validate.notNull(type, (String)"target type must be not null", (Object[])new Object[0]);
        Validate.notNull((Object)gson, (String)"gson must be not null", (Object[])new Object[0]);
        return (T)gson.fromJson(json, type);
    }

    public static <T> List<T> jsonToList(String json, Class<T> type) {
        return GsonUtils.jsonToList(json, type, DEFAULT_GSON);
    }

    public static <T> List<T> jsonToList(String json, Class<T> type, Gson gson) {
        Validate.notBlank((CharSequence)json, (String)"json content must be not null", (Object[])new Object[0]);
        Validate.notNull(type, (String)"target type must be not null", (Object[])new Object[0]);
        Validate.notNull((Object)gson, (String)"gson must be not null", (Object[])new Object[0]);
        JsonArray arrayJson = JsonParser.parseString((String)json).getAsJsonArray();
        ArrayList<Object> results = new ArrayList<Object>();
        for (JsonElement element : arrayJson) {
            results.add(gson.fromJson(element, type));
        }
        return results;
    }

    public static <T> List<T> jsonToList2(String json, Class<T> type) {
        return GsonUtils.jsonToList2(json, type, DEFAULT_GSON);
    }

    public static <T> List<T> jsonToList2(String json, Class<T> type, Gson gson) {
        Validate.notBlank((CharSequence)json, (String)"json content must be not null", (Object[])new Object[0]);
        Validate.notNull(type, (String)"target type must be not null", (Object[])new Object[0]);
        Validate.notNull((Object)gson, (String)"gson must be not null", (Object[])new Object[0]);
        return (List)gson.fromJson(json, new TypeToken<List<T>>(){}.getType());
    }

    public static String objectToJson(Object source) {
        return GsonUtils.objectToJson(source, DEFAULT_GSON);
    }

    public static String objectToJson(Object source, Gson gson) {
        Validate.notNull((Object)source, (String)"source object must be not null", (Object[])new Object[0]);
        Validate.notNull((Object)gson, (String)"gson must be not null", (Object[])new Object[0]);
        return gson.toJson(source);
    }

    public static <T> T mapToObject(Map<String, ?> sourceMap, Class<T> type) {
        return GsonUtils.mapToObject(sourceMap, type, DEFAULT_GSON);
    }

    public static <T> T mapToObject(Map<String, ?> sourceMap, Class<T> type, Gson gson) {
        Validate.notNull(sourceMap, (String)"source map must be not null", (Object[])new Object[0]);
        String json = GsonUtils.objectToJson(sourceMap, gson);
        return GsonUtils.jsonToObject(json, type, gson);
    }

    public static Map<?, ?> objectToMap(Object source) {
        return GsonUtils.objectToMap(source, DEFAULT_GSON);
    }

    public static Map<?, ?> objectToMap(Object source, Gson gson) {
        String json = GsonUtils.objectToJson(source, gson);
        return GsonUtils.jsonToObject(json, Map.class, gson);
    }
}

