/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.json.jackson;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.hb0730.commons.lang.Validate;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class JacksonUtils {
    public static final ObjectMapper DEFAULT_JSON_MAPPER = JacksonUtils.createDefaultJsonMapper();

    private JacksonUtils() {
    }

    public static ObjectMapper createDefaultJsonMapper() {
        return JacksonUtils.createDefaultJsonMapper(null);
    }

    public static ObjectMapper createDefaultJsonMapper(PropertyNamingStrategy strategy) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        if (strategy != null) {
            mapper.setPropertyNamingStrategy(strategy);
        }
        return mapper;
    }

    public static <T> T jsonToObject(String json, Class<T> type) throws IOException {
        return JacksonUtils.jsonToObject(json, type, DEFAULT_JSON_MAPPER);
    }

    public static <T> T jsonToObject(String json, Class<T> type, ObjectMapper objectMapper) throws IOException {
        Validate.notBlank((CharSequence)json, (String)"json content must be not null", (Object[])new Object[0]);
        Validate.notNull(type, (String)"target type must be not null", (Object[])new Object[0]);
        Validate.notNull((Object)objectMapper, (String)"object mapper must be not null", (Object[])new Object[0]);
        return (T)objectMapper.readValue(json, type);
    }

    public static <T> List<T> jsonToList(String json, Class<T> type) throws IOException {
        return JacksonUtils.jsonToList(json, type, DEFAULT_JSON_MAPPER);
    }

    public static <T> List<T> jsonToList(String json, Class<T> type, ObjectMapper objectMapper) throws IOException {
        Validate.notBlank((CharSequence)json, (String)"json content must be not null", (Object[])new Object[0]);
        Validate.notNull(type, (String)"target type must be not null", (Object[])new Object[0]);
        Validate.notNull((Object)objectMapper, (String)"object mapper must be not null", (Object[])new Object[0]);
        CollectionType collectionType = objectMapper.getTypeFactory().constructCollectionType(List.class, type);
        return (List)objectMapper.readValue(json, (JavaType)collectionType);
    }

    public static <T> List<T> jsonToList2(String json, Class<T> type) throws IOException {
        return JacksonUtils.jsonToList2(json, type, DEFAULT_JSON_MAPPER);
    }

    public static <T> List<T> jsonToList2(String json, Class<T> type, ObjectMapper objectMapper) throws IOException {
        Validate.notBlank((CharSequence)json, (String)"json content must be not null", (Object[])new Object[0]);
        Validate.notNull(type, (String)"target type must be not null", (Object[])new Object[0]);
        Validate.notNull((Object)objectMapper, (String)"object mapper must be not null", (Object[])new Object[0]);
        return (List)objectMapper.readValue(json, new TypeReference<List<T>>(){});
    }

    public static String objectToJson(Object source) throws IOException {
        return JacksonUtils.objectToJson(source, DEFAULT_JSON_MAPPER);
    }

    public static String objectToJson(Object source, ObjectMapper objectMapper) throws IOException {
        Validate.notNull((Object)source, (String)"source object must be not null", (Object[])new Object[0]);
        Validate.notNull((Object)objectMapper, (String)"object mapper must be not null", (Object[])new Object[0]);
        return objectMapper.writeValueAsString(source);
    }

    public static <T> T mapToObject(Map<String, ?> sourceMap, Class<T> type) throws IOException {
        return JacksonUtils.mapToObject(sourceMap, type, DEFAULT_JSON_MAPPER);
    }

    public static <T> T mapToObject(Map<String, ?> sourceMap, Class<T> type, ObjectMapper objectMapper) throws IOException {
        Validate.notNull(sourceMap, (String)"source map must be not null", (Object[])new Object[0]);
        String json = JacksonUtils.objectToJson(sourceMap, objectMapper);
        return JacksonUtils.jsonToObject(json, type, objectMapper);
    }

    public static Map<?, ?> objectToMap(Object source) throws IOException {
        return JacksonUtils.objectToMap(source, DEFAULT_JSON_MAPPER);
    }

    public static Map<?, ?> objectToMap(Object source, ObjectMapper objectMapper) throws IOException {
        String json = JacksonUtils.objectToJson(source, objectMapper);
        return JacksonUtils.jsonToObject(json, Map.class, objectMapper);
    }
}

