/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.json.utils;

import com.hb0730.commons.json.AbstractJson;
import com.hb0730.commons.json.IJson;
import com.hb0730.commons.json.exceptions.JsonException;
import com.hb0730.commons.json.fastjson.FastJsonImpl;
import com.hb0730.commons.json.gson.GsonImpl;
import com.hb0730.commons.json.jackson.JacksonImpl;
import com.hb0730.commons.lang.ClassUtils;
import java.util.List;
import java.util.Map;

public class Jsons
implements IJson {
    public static final Jsons JSONS = new Jsons();
    private AbstractJson proxy;

    private void selectProxy() throws JsonException {
        AbstractJson defaultProxy = null;
        ClassLoader classLoader = Jsons.class.getClassLoader();
        if (ClassUtils.isPresent((String)"com.alibaba.fastjson.JSON", (ClassLoader)classLoader)) {
            defaultProxy = this.getProxy(FastJsonImpl.class);
        }
        if (ClassUtils.isPresent((String)"com.google.gson.Gson", (ClassLoader)classLoader)) {
            defaultProxy = this.getProxy(GsonImpl.class);
        }
        if (ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)classLoader)) {
            defaultProxy = this.getProxy(JacksonImpl.class);
        }
        if (defaultProxy == null) {
            throw new JsonException("Has no JsonImpl defined in environment!");
        }
        this.proxy = defaultProxy;
    }

    private <T extends AbstractJson> AbstractJson getProxy(Class<T> clazz) {
        try {
            return (AbstractJson)clazz.newInstance();
        }
        catch (Throwable e) {
            return null;
        }
    }

    public Jsons setJson(AbstractJson support) {
        this.proxy = support;
        return this;
    }

    public IJson getCurrentJson() {
        return this.proxy;
    }

    public Jsons setJson(Class<? extends AbstractJson> support) {
        this.proxy = this.getProxy(support);
        return this;
    }

    private void checkProxyNotNull(AbstractJson proxy) throws JsonException {
        if (null == proxy) {
            this.selectProxy();
        }
    }

    @Override
    public <T> T jsonToObject(String json, Class<T> type) throws JsonException {
        this.checkProxyNotNull(this.proxy);
        return this.proxy.jsonToObject(json, type);
    }

    @Override
    public <T> T jsonToObject(String json, Class<T> type, Object mapper) throws JsonException {
        this.checkProxyNotNull(this.proxy);
        return this.proxy.jsonToObject(json, type, mapper);
    }

    @Override
    public <T> List<T> jsonToList(String json, Class<T> type) throws JsonException {
        this.checkProxyNotNull(this.proxy);
        return this.proxy.jsonToList(json, type);
    }

    @Override
    public <T> List<T> jsonToList(String json, Class<T> type, Object mapper) throws JsonException {
        this.checkProxyNotNull(this.proxy);
        return this.proxy.jsonToList(json, type, mapper);
    }

    @Override
    public String objectToJson(Object source) throws JsonException {
        this.checkProxyNotNull(this.proxy);
        return this.proxy.objectToJson(source);
    }

    @Override
    public String objectToJson(Object source, Object mapper) throws JsonException {
        this.checkProxyNotNull(this.proxy);
        return this.proxy.objectToJson(source, mapper);
    }

    @Override
    public <T> T mapToObject(Map<String, ?> sourceMap, Class<T> type) throws JsonException {
        this.checkProxyNotNull(this.proxy);
        return this.proxy.mapToObject(sourceMap, type);
    }

    @Override
    public <T> T mapToObject(Map<String, ?> sourceMap, Class<T> type, Object mapper) throws JsonException {
        this.checkProxyNotNull(this.proxy);
        return this.proxy.mapToObject(sourceMap, type, mapper);
    }

    @Override
    public <T> Map<String, T> objectToMap(Object source) throws JsonException {
        this.checkProxyNotNull(this.proxy);
        return this.proxy.objectToMap(source);
    }

    @Override
    public <T> Map<String, T> objectToMap(Object source, Object mapper) throws JsonException {
        this.checkProxyNotNull(this.proxy);
        return this.proxy.objectToMap(source, mapper);
    }
}

